package io.k8s.api.core.v1

/* A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future. */
import io.circe._
import io.circe.generic.semiauto._

case class TopologySelectorTerm(
  /* A list of topology selector requirements by labels. */
  matchLabelExpressions: Option[Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]] = None
)

object TopologySelectorTerm {
  implicit lazy val encoder: Encoder.AsObject[TopologySelectorTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[TopologySelectorTerm] = deriveDecoder
}
