package io.k8s.api.core.v1

/* TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace. */
import io.circe._
import io.circe.generic.semiauto._

case class TypedLocalObjectReference(
  /* Kind is the type of resource being referenced */
  kind: String,
  /* Name is the name of resource being referenced */
  name: String,
  /* APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required. */
  apiGroup: Option[String] = None
)

object TypedLocalObjectReference {
  implicit lazy val encoder: Encoder.AsObject[TypedLocalObjectReference] = deriveEncoder
  implicit lazy val decoder: Decoder[TypedLocalObjectReference] = deriveDecoder
}
