package io.k8s.api.storage.v1alpha1

/* VolumeAttachmentSpec is the specification of a VolumeAttachment request. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeAttachmentSpec(
  /* Attacher indicates the name of the volume driver that MUST handle this request. This is the name returned by GetPluginName(). */
  attacher: String,
  /* Source represents the volume that should be attached. */
  source: io.k8s.api.storage.v1alpha1.VolumeAttachmentSource,
  /* The node that the volume should be attached to. */
  nodeName: String
)

object VolumeAttachmentSpec {
  implicit lazy val encoder: Encoder.AsObject[VolumeAttachmentSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeAttachmentSpec] = deriveDecoder
}
