package io.k8s.api.storage.v1

/* VolumeNodeResources is a set of resource limits for scheduling of volumes. */
import io.circe._
import io.circe.generic.semiauto._

case class VolumeNodeResources(
  /* Maximum number of unique volumes managed by the CSI driver that can be used on a node. A volume that is both attached and mounted on a node is considered to be used once, not twice. The same rule applies for a unique volume that is shared among multiple pods on the same node. If this field is not specified, then the supported number of volumes on this node is unbounded. */
  count: Option[Int] = None
)

object VolumeNodeResources {
  implicit lazy val encoder: Encoder.AsObject[VolumeNodeResources] = deriveEncoder
  implicit lazy val decoder: Decoder[VolumeNodeResources] = deriveDecoder
}
