package io.k8s.api.core.v1

/* The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s) */
import io.circe._
import io.circe.generic.semiauto._

case class WeightedPodAffinityTerm(
  /* weight associated with matching the corresponding podAffinityTerm, in the range 1-100. */
  weight: Int,
  /* Required. A pod affinity term, associated with the corresponding weight. */
  podAffinityTerm: io.k8s.api.core.v1.PodAffinityTerm
)

object WeightedPodAffinityTerm {
  implicit lazy val encoder: Encoder.AsObject[WeightedPodAffinityTerm] = deriveEncoder
  implicit lazy val decoder: Decoder[WeightedPodAffinityTerm] = deriveDecoder
}
