/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel;

import com.atlassian.braid.Braid;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.document.TypeMappers;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.language.Definition;
import graphql.language.FieldDefinition;
import graphql.language.SDLDefinition;
import graphql.language.Type;
import graphql.nadel.GraphQLRemoteRetrieverFactory;
import graphql.nadel.GraphQLRemoteSchemaSourceFactory;
import graphql.nadel.InvalidDslException;
import graphql.nadel.Parser;
import graphql.nadel.SchemaSourceFactory;
import graphql.nadel.SchemaTransformationsFactory;
import graphql.nadel.TransformationUtils;
import graphql.nadel.dsl.FieldTransformation;
import graphql.nadel.dsl.InnerServiceHydration;
import graphql.nadel.dsl.RemoteArgumentDefinition;
import graphql.nadel.dsl.ServiceDefinition;
import graphql.nadel.dsl.StitchingDsl;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@PublicApi
public class Nadel {
    private StitchingDsl stitchingDsl;
    private Parser parser = new Parser();
    private Braid braid;
    private final Map<String, TypeDefinitionRegistry> typesByService = new LinkedHashMap<String, TypeDefinitionRegistry>();
    private final Map<String, SchemaNamespace> namespaceByService = new LinkedHashMap<String, SchemaNamespace>();

    public Nadel(String dsl, GraphQLRemoteRetrieverFactory<?> graphQLRemoteRetrieverFactory) {
        this(dsl, new GraphQLRemoteSchemaSourceFactory(graphQLRemoteRetrieverFactory), SchemaTransformationsFactory.DEFAULT);
    }

    public Nadel(String dsl, SchemaSourceFactory schemaSourceFactory, SchemaTransformationsFactory transformationsFactory) {
        Objects.requireNonNull(dsl, "dsl");
        Objects.requireNonNull(schemaSourceFactory, "schemaSourceFactory");
        Objects.requireNonNull(transformationsFactory, "transformationsFactory");
        this.stitchingDsl = this.parser.parseDSL(dsl);
        List<ServiceDefinition> serviceDefinitions = this.stitchingDsl.getServiceDefinitions();
        for (ServiceDefinition serviceDefinition : serviceDefinitions) {
            TypeDefinitionRegistry typeDefinitionRegistry = this.buildRegistry(serviceDefinition);
            this.typesByService.put(serviceDefinition.getName(), typeDefinitionRegistry);
            SchemaNamespace schemaNamespace = SchemaNamespace.of((String)serviceDefinition.getName());
            this.namespaceByService.put(serviceDefinition.getName(), schemaNamespace);
        }
        ArrayList<SchemaSource> schemaSources = new ArrayList<SchemaSource>();
        for (ServiceDefinition serviceDefinition : serviceDefinitions) {
            SchemaNamespace namespace = this.namespaceByService.get(serviceDefinition.getName());
            TypeDefinitionRegistry typeDefinitionRegistry = this.typesByService.get(serviceDefinition.getName());
            List<TransformationUtils.FieldDefinitionWithParentType> defs = TransformationUtils.collectFieldTransformations(serviceDefinition);
            List<Link> links = this.createLinks(namespace, defs);
            List<TypeMapper> mappers = this.createMappers(defs);
            SchemaSource schemaSource = schemaSourceFactory.createSchemaSource(serviceDefinition, namespace, typeDefinitionRegistry, links, mappers);
            schemaSources.add(schemaSource);
        }
        AsyncExecutionStrategy asyncExecutionStrategy = new AsyncExecutionStrategy();
        List<SchemaTransformation> schemaTransformations = transformationsFactory.create(this.typesByService);
        this.braid = Braid.builder().executionStrategy((ExecutionStrategy)asyncExecutionStrategy).customSchemaTransformations(schemaTransformations).schemaSources(schemaSources).build();
    }

    public TypeDefinitionRegistry buildRegistry(ServiceDefinition serviceDefinition) {
        ArrayList errors = new ArrayList();
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        for (Definition definition : serviceDefinition.getTypeDefinitions()) {
            if (!(definition instanceof SDLDefinition)) continue;
            typeRegistry.add((SDLDefinition)definition).ifPresent(errors::add);
        }
        if (errors.size() > 0) {
            throw new SchemaProblem(errors);
        }
        return typeRegistry;
    }

    private List<Link> createLinks(SchemaNamespace schemaNamespace, List<TransformationUtils.FieldDefinitionWithParentType> defs) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (TransformationUtils.FieldDefinitionWithParentType definition : defs) {
            FieldTransformation transformation = definition.field().getFieldTransformation();
            if (transformation.getInnerServiceHydration() == null) continue;
            InnerServiceHydration hydration = transformation.getInnerServiceHydration();
            Link link = this.createHydrationLink(schemaNamespace, definition, hydration);
            links.add(link);
        }
        return links;
    }

    private List<TypeMapper> createMappers(List<TransformationUtils.FieldDefinitionWithParentType> defs) {
        LinkedHashMap<String, TypeMapper> typeMapperMap = new LinkedHashMap<String, TypeMapper>();
        for (TransformationUtils.FieldDefinitionWithParentType definition : defs) {
            FieldTransformation transformation = definition.field().getFieldTransformation();
            if (transformation.getFieldMappingDefinition() == null) continue;
            typeMapperMap.compute(definition.parentType(), (k, v) -> (v == null ? TypeMappers.typeNamed((String)definition.parentType()) : v).copy(definition.field().getName(), transformation.getFieldMappingDefinition().getInputName()));
        }
        return typeMapperMap.values().stream().map(TypeMapper::copyRemaining).collect(Collectors.toList());
    }

    private Link createHydrationLink(SchemaNamespace schemaNamespace, TransformationUtils.FieldDefinitionWithParentType definition, InnerServiceHydration hydration) {
        SchemaNamespace targetService = (SchemaNamespace)Assert.assertNotNull((Object)this.namespaceByService.get(hydration.getServiceName()));
        FieldDefinition targetField = this.findTargetFieldForHydration(hydration);
        String targetTypeName = TypeInfo.typeInfo((Type)targetField.getType()).getName();
        RemoteArgumentDefinition argument = (RemoteArgumentDefinition)((Object)hydration.getArguments().stream().findFirst().orElseThrow(() -> new InvalidDslException("Remote argument is required.", hydration.getSourceLocation())));
        return Link.from((SchemaNamespace)schemaNamespace, (String)definition.parentType(), (String)definition.field().getName(), (String)argument.getFieldMappingDefinition().getInputName()).to(targetService, targetTypeName, targetField.getName()).argument(argument.getName()).build();
    }

    private FieldDefinition findTargetFieldForHydration(InnerServiceHydration hydration) {
        TypeDefinitionRegistry types = this.typesByService.get(hydration.getServiceName());
        if (types == null) {
            throw this.hydrationError(hydration, "Service '%s' is not defined.", hydration.getServiceName());
        }
        return (FieldDefinition)TypeUtils.findQueryFieldDefinitions((TypeDefinitionRegistry)types).flatMap(queryFields -> queryFields.stream().filter(field -> hydration.getTopLevelField().equals(field.getName())).findFirst()).orElseThrow(() -> this.hydrationError(hydration, "Service '%s' does not contain query field '%s'", hydration.getServiceName(), hydration.getTopLevelField()));
    }

    private InvalidDslException hydrationError(InnerServiceHydration hydration, String format, Object ... args) {
        return new InvalidDslException(String.format("Error in field hydration definition: " + format, args), hydration.getSourceLocation());
    }

    public CompletableFuture<ExecutionResult> executeAsync(ExecutionInput executionInput) {
        return this.braid.newGraphQL().execute(executionInput);
    }
}

