/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel;

import graphql.Internal;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.TypeDefinition;
import graphql.nadel.dsl.FieldDefinitionWithTransformation;
import graphql.nadel.dsl.ServiceDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

@Internal
public final class TransformationUtils {
    private TransformationUtils() {
    }

    public static List<FieldDefinitionWithParentType> collectFieldTransformations(ServiceDefinition serviceDefinition) {
        NodeTraverser traverser = new NodeTraverser();
        FieldTransformationVisitor visitor = new FieldTransformationVisitor();
        traverser.depthFirst((NodeVisitor)visitor, serviceDefinition.getChildren());
        return visitor.definitions();
    }

    private static class FieldTransformationVisitor
    extends NodeVisitorStub {
        private final Stack<String> typeStack = new Stack();
        private List<FieldDefinitionWithParentType> definitions = new ArrayList<FieldDefinitionWithParentType>();

        private FieldTransformationVisitor() {
        }

        public TraversalControl visitFieldDefinition(FieldDefinition node, TraverserContext<Node> context) {
            if (context.getVar(NodeTraverser.LeaveOrEnter.class) != NodeTraverser.LeaveOrEnter.ENTER && node instanceof FieldDefinitionWithTransformation) {
                this.definitions.add(new FieldDefinitionWithParentType((FieldDefinitionWithTransformation)node, this.typeStack.peek()));
            }
            return super.visitFieldDefinition(node, context);
        }

        public TraversalControl visitInputValueDefinition(InputValueDefinition node, TraverserContext<Node> context) {
            return TraversalControl.ABORT;
        }

        protected TraversalControl visitTypeDefinition(TypeDefinition<?> node, TraverserContext<Node> context) {
            switch ((NodeTraverser.LeaveOrEnter)context.getVar(NodeTraverser.LeaveOrEnter.class)) {
                case ENTER: {
                    this.typeStack.push(node.getName());
                    break;
                }
                case LEAVE: {
                    this.typeStack.pop();
                }
            }
            return super.visitTypeDefinition(node, context);
        }

        public List<FieldDefinitionWithParentType> definitions() {
            return this.definitions;
        }
    }

    public static class FieldDefinitionWithParentType {
        private final FieldDefinitionWithTransformation field;
        private final String parentType;

        private FieldDefinitionWithParentType(FieldDefinitionWithTransformation field, String parentType) {
            this.field = field;
            this.parentType = parentType;
        }

        public FieldDefinitionWithTransformation field() {
            return this.field;
        }

        public String parentType() {
            return this.parentType;
        }
    }
}

