/*
 * Decompiled with CFR 0.152.
 */
package graphql.nadel.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.NodeBuilder;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.nadel.parser.antlr.StitchingDSLParser;
import graphql.parser.StringValueParsing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

@Internal
public class GraphqlAntlrToLanguage {
    private final CommonTokenStream tokens;

    public GraphqlAntlrToLanguage(CommonTokenStream tokens) {
        this.tokens = tokens;
    }

    protected SDLDefinition createTypeSystemDefinition(StitchingDSLParser.TypeSystemDefinitionContext ctx) {
        if (ctx.schemaDefinition() != null) {
            return this.createSchemaDefinition(ctx.schemaDefinition());
        }
        if (ctx.directiveDefinition() != null) {
            return this.createDirectiveDefinition(ctx.directiveDefinition());
        }
        if (ctx.typeDefinition() != null) {
            return this.createTypeDefinition(ctx.typeDefinition());
        }
        if (ctx.typeExtension() != null) {
            return this.createTypeExtension(ctx.typeExtension());
        }
        return (SDLDefinition)Assert.assertShouldNeverHappen();
    }

    protected TypeDefinition createTypeExtension(StitchingDSLParser.TypeExtensionContext ctx) {
        if (ctx.enumTypeExtensionDefinition() != null) {
            return this.createEnumTypeExtensionDefinition(ctx.enumTypeExtensionDefinition());
        }
        if (ctx.objectTypeExtensionDefinition() != null) {
            return this.createObjectTypeExtensionDefinition(ctx.objectTypeExtensionDefinition());
        }
        if (ctx.inputObjectTypeExtensionDefinition() != null) {
            return this.createInputObjectTypeExtensionDefinition(ctx.inputObjectTypeExtensionDefinition());
        }
        if (ctx.interfaceTypeExtensionDefinition() != null) {
            return this.createInterfaceTypeExtensionDefinition(ctx.interfaceTypeExtensionDefinition());
        }
        if (ctx.scalarTypeExtensionDefinition() != null) {
            return this.createScalarTypeExtensionDefinition(ctx.scalarTypeExtensionDefinition());
        }
        if (ctx.unionTypeExtensionDefinition() != null) {
            return this.createUnionTypeExtensionDefinition(ctx.unionTypeExtensionDefinition());
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen();
    }

    protected TypeDefinition createTypeDefinition(StitchingDSLParser.TypeDefinitionContext ctx) {
        if (ctx.enumTypeDefinition() != null) {
            return this.createEnumTypeDefinition(ctx.enumTypeDefinition());
        }
        if (ctx.objectTypeDefinition() != null) {
            return this.createObjectTypeDefinition(ctx.objectTypeDefinition());
        }
        if (ctx.inputObjectTypeDefinition() != null) {
            return this.createInputObjectTypeDefinition(ctx.inputObjectTypeDefinition());
        }
        if (ctx.interfaceTypeDefinition() != null) {
            return this.createInterfaceTypeDefinition(ctx.interfaceTypeDefinition());
        }
        if (ctx.scalarTypeDefinition() != null) {
            return this.createScalarTypeDefinition(ctx.scalarTypeDefinition());
        }
        if (ctx.unionTypeDefinition() != null) {
            return this.createUnionTypeDefinition(ctx.unionTypeDefinition());
        }
        return (TypeDefinition)Assert.assertShouldNeverHappen();
    }

    protected Type createType(StitchingDSLParser.TypeContext ctx) {
        if (ctx.typeName() != null) {
            return this.createTypeName(ctx.typeName());
        }
        if (ctx.nonNullType() != null) {
            return this.createNonNullType(ctx.nonNullType());
        }
        if (ctx.listType() != null) {
            return this.createListType(ctx.listType());
        }
        return (Type)Assert.assertShouldNeverHappen();
    }

    protected TypeName createTypeName(StitchingDSLParser.TypeNameContext ctx) {
        TypeName.Builder builder = TypeName.newTypeName();
        builder.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)builder, ctx);
        return builder.build();
    }

    protected NonNullType createNonNullType(StitchingDSLParser.NonNullTypeContext ctx) {
        NonNullType.Builder builder = NonNullType.newNonNullType();
        this.addCommonData((NodeBuilder)builder, ctx);
        if (ctx.listType() != null) {
            builder.type(this.createListType(ctx.listType()));
        } else if (ctx.typeName() != null) {
            builder.type(this.createTypeName(ctx.typeName()));
        } else {
            return (NonNullType)Assert.assertShouldNeverHappen();
        }
        return builder.build();
    }

    protected ListType createListType(StitchingDSLParser.ListTypeContext ctx) {
        ListType.Builder builder = ListType.newListType();
        this.addCommonData((NodeBuilder)builder, ctx);
        builder.type(this.createType(ctx.type()));
        return builder.build();
    }

    protected Argument createArgument(StitchingDSLParser.ArgumentContext ctx) {
        Argument.Builder builder = Argument.newArgument();
        this.addCommonData((NodeBuilder)builder, ctx);
        builder.name(ctx.name().getText());
        builder.value(this.createValue(ctx.valueWithVariable()));
        return builder.build();
    }

    protected List<Argument> createArguments(StitchingDSLParser.ArgumentsContext ctx) {
        if (ctx == null) {
            return new ArrayList<Argument>();
        }
        return ctx.argument().stream().map(this::createArgument).collect(Collectors.toList());
    }

    protected List<Directive> createDirectives(StitchingDSLParser.DirectivesContext ctx) {
        if (ctx == null) {
            return new ArrayList<Directive>();
        }
        return ctx.directive().stream().map(this::createDirective).collect(Collectors.toList());
    }

    protected Directive createDirective(StitchingDSLParser.DirectiveContext ctx) {
        Directive.Builder builder = Directive.newDirective();
        builder.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)builder, ctx);
        builder.arguments(this.createArguments(ctx.arguments()));
        return builder.build();
    }

    protected SchemaDefinition createSchemaDefinition(StitchingDSLParser.SchemaDefinitionContext ctx) {
        SchemaDefinition.Builder def = SchemaDefinition.newSchemaDefinition();
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        def.operationTypeDefinitions(ctx.operationTypeDefinition().stream().map(this::createOperationTypeDefinition).collect(Collectors.toList()));
        return def.build();
    }

    protected OperationTypeDefinition createOperationTypeDefinition(StitchingDSLParser.OperationTypeDefinitionContext ctx) {
        OperationTypeDefinition.Builder def = OperationTypeDefinition.newOperationTypeDefinition();
        def.name(ctx.operationType().getText());
        def.type((Type)this.createTypeName(ctx.typeName()));
        this.addCommonData((NodeBuilder)def, ctx);
        return def.build();
    }

    protected ScalarTypeDefinition createScalarTypeDefinition(StitchingDSLParser.ScalarTypeDefinitionContext ctx) {
        ScalarTypeDefinition.Builder def = ScalarTypeDefinition.newScalarTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected ScalarTypeExtensionDefinition createScalarTypeExtensionDefinition(StitchingDSLParser.ScalarTypeExtensionDefinitionContext ctx) {
        ScalarTypeExtensionDefinition.Builder def = ScalarTypeExtensionDefinition.newScalarTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected ObjectTypeDefinition createObjectTypeDefinition(StitchingDSLParser.ObjectTypeDefinitionContext ctx) {
        ObjectTypeDefinition.Builder def = ObjectTypeDefinition.newObjectTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList implementz = new ArrayList();
        for (StitchingDSLParser.ImplementsInterfacesContext implementsInterfacesContext = ctx.implementsInterfaces(); implementsInterfacesContext != null; implementsInterfacesContext = implementsInterfacesContext.implementsInterfaces()) {
            List typeNames = implementsInterfacesContext.typeName().stream().map(this::createTypeName).collect(Collectors.toList());
            implementz.addAll(0, typeNames);
        }
        def.implementz(implementz);
        if (ctx.fieldsDefinition() != null) {
            def.fieldDefinitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        }
        return def.build();
    }

    protected ObjectTypeExtensionDefinition createObjectTypeExtensionDefinition(StitchingDSLParser.ObjectTypeExtensionDefinitionContext ctx) {
        ObjectTypeExtensionDefinition.Builder def = ObjectTypeExtensionDefinition.newObjectTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList implementz = new ArrayList();
        for (StitchingDSLParser.ImplementsInterfacesContext implementsInterfacesContext = ctx.implementsInterfaces(); implementsInterfacesContext != null; implementsInterfacesContext = implementsInterfacesContext.implementsInterfaces()) {
            List typeNames = implementsInterfacesContext.typeName().stream().map(this::createTypeName).collect(Collectors.toList());
            implementz.addAll(0, typeNames);
        }
        def.implementz(implementz);
        if (ctx.fieldsDefinition() != null) {
            def.fieldDefinitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        }
        return def.build();
    }

    protected List<FieldDefinition> createFieldDefinitions(StitchingDSLParser.FieldsDefinitionContext ctx) {
        if (ctx == null) {
            return new ArrayList<FieldDefinition>();
        }
        return ctx.fieldDefinition().stream().map(this::createFieldDefinition).collect(Collectors.toList());
    }

    protected FieldDefinition createFieldDefinition(StitchingDSLParser.FieldDefinitionContext ctx) {
        FieldDefinition.Builder def = FieldDefinition.newFieldDefinition();
        def.name(ctx.name().getText());
        def.type(this.createType(ctx.type()));
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.argumentsDefinition() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.argumentsDefinition().inputValueDefinition()));
        }
        return def.build();
    }

    protected List<InputValueDefinition> createInputValueDefinitions(List<StitchingDSLParser.InputValueDefinitionContext> defs) {
        return defs.stream().map(this::createInputValueDefinition).collect(Collectors.toList());
    }

    protected InputValueDefinition createInputValueDefinition(StitchingDSLParser.InputValueDefinitionContext ctx) {
        InputValueDefinition.Builder def = InputValueDefinition.newInputValueDefinition();
        def.name(ctx.name().getText());
        def.type(this.createType(ctx.type()));
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        if (ctx.defaultValue() != null) {
            def.defaultValue(this.createValue(ctx.defaultValue().value()));
        }
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected InterfaceTypeDefinition createInterfaceTypeDefinition(StitchingDSLParser.InterfaceTypeDefinitionContext ctx) {
        InterfaceTypeDefinition.Builder def = InterfaceTypeDefinition.newInterfaceTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        def.definitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        return def.build();
    }

    protected InterfaceTypeExtensionDefinition createInterfaceTypeExtensionDefinition(StitchingDSLParser.InterfaceTypeExtensionDefinitionContext ctx) {
        InterfaceTypeExtensionDefinition.Builder def = InterfaceTypeExtensionDefinition.newInterfaceTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        def.definitions(this.createFieldDefinitions(ctx.fieldsDefinition()));
        return def.build();
    }

    protected UnionTypeDefinition createUnionTypeDefinition(StitchingDSLParser.UnionTypeDefinitionContext ctx) {
        UnionTypeDefinition.Builder def = UnionTypeDefinition.newUnionTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<TypeName> members = new ArrayList<TypeName>();
        for (StitchingDSLParser.UnionMembersContext unionMembersContext = ctx.unionMembership().unionMembers(); unionMembersContext != null; unionMembersContext = unionMembersContext.unionMembers()) {
            members.add(0, this.createTypeName(unionMembersContext.typeName()));
        }
        def.memberTypes(members);
        return def.build();
    }

    protected UnionTypeExtensionDefinition createUnionTypeExtensionDefinition(StitchingDSLParser.UnionTypeExtensionDefinitionContext ctx) {
        UnionTypeExtensionDefinition.Builder def = UnionTypeExtensionDefinition.newUnionTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        ArrayList<TypeName> members = new ArrayList<TypeName>();
        if (ctx.unionMembership() != null) {
            for (StitchingDSLParser.UnionMembersContext unionMembersContext = ctx.unionMembership().unionMembers(); unionMembersContext != null; unionMembersContext = unionMembersContext.unionMembers()) {
                members.add(0, this.createTypeName(unionMembersContext.typeName()));
            }
            def.memberTypes(members);
        }
        return def.build();
    }

    protected EnumTypeDefinition createEnumTypeDefinition(StitchingDSLParser.EnumTypeDefinitionContext ctx) {
        EnumTypeDefinition.Builder def = EnumTypeDefinition.newEnumTypeDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.enumValueDefinitions() != null) {
            def.enumValueDefinitions(ctx.enumValueDefinitions().enumValueDefinition().stream().map(this::createEnumValueDefinition).collect(Collectors.toList()));
        }
        return def.build();
    }

    protected EnumTypeExtensionDefinition createEnumTypeExtensionDefinition(StitchingDSLParser.EnumTypeExtensionDefinitionContext ctx) {
        EnumTypeExtensionDefinition.Builder def = EnumTypeExtensionDefinition.newEnumTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.enumValueDefinitions() != null) {
            def.enumValueDefinitions(ctx.enumValueDefinitions().enumValueDefinition().stream().map(this::createEnumValueDefinition).collect(Collectors.toList()));
        }
        return def.build();
    }

    protected EnumValueDefinition createEnumValueDefinition(StitchingDSLParser.EnumValueDefinitionContext ctx) {
        EnumValueDefinition.Builder def = EnumValueDefinition.newEnumValueDefinition();
        def.name(ctx.enumValue().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        return def.build();
    }

    protected InputObjectTypeDefinition createInputObjectTypeDefinition(StitchingDSLParser.InputObjectTypeDefinitionContext ctx) {
        InputObjectTypeDefinition.Builder def = InputObjectTypeDefinition.newInputObjectDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.inputObjectValueDefinitions() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.inputObjectValueDefinitions().inputValueDefinition()));
        }
        return def.build();
    }

    protected InputObjectTypeExtensionDefinition createInputObjectTypeExtensionDefinition(StitchingDSLParser.InputObjectTypeExtensionDefinitionContext ctx) {
        InputObjectTypeExtensionDefinition.Builder def = InputObjectTypeExtensionDefinition.newInputObjectTypeExtensionDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.directives(this.createDirectives(ctx.directives()));
        if (ctx.inputObjectValueDefinitions() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.inputObjectValueDefinitions().inputValueDefinition()));
        }
        return def.build();
    }

    protected DirectiveDefinition createDirectiveDefinition(StitchingDSLParser.DirectiveDefinitionContext ctx) {
        DirectiveDefinition.Builder def = DirectiveDefinition.newDirectiveDefinition();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        def.description(this.newDescription(ctx.description()));
        ArrayList<DirectiveLocation> directiveLocations = new ArrayList<DirectiveLocation>();
        for (StitchingDSLParser.DirectiveLocationsContext directiveLocationsContext = ctx.directiveLocations(); directiveLocationsContext != null; directiveLocationsContext = directiveLocationsContext.directiveLocations()) {
            directiveLocations.add(0, this.createDirectiveLocation(directiveLocationsContext.directiveLocation()));
        }
        def.directiveLocations(directiveLocations);
        if (ctx.argumentsDefinition() != null) {
            def.inputValueDefinitions(this.createInputValueDefinitions(ctx.argumentsDefinition().inputValueDefinition()));
        }
        return def.build();
    }

    protected DirectiveLocation createDirectiveLocation(StitchingDSLParser.DirectiveLocationContext ctx) {
        DirectiveLocation.Builder def = DirectiveLocation.newDirectiveLocation();
        def.name(ctx.name().getText());
        this.addCommonData((NodeBuilder)def, ctx);
        return def.build();
    }

    protected Value createValue(StitchingDSLParser.ValueWithVariableContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue.Builder intValue = IntValue.newIntValue().value(new BigInteger(ctx.IntValue().getText()));
            this.addCommonData((NodeBuilder)intValue, ctx);
            return intValue.build();
        }
        if (ctx.FloatValue() != null) {
            FloatValue.Builder floatValue = FloatValue.newFloatValue().value(new BigDecimal(ctx.FloatValue().getText()));
            this.addCommonData((NodeBuilder)floatValue, ctx);
            return floatValue.build();
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue.Builder booleanValue = BooleanValue.newBooleanValue().value(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.addCommonData((NodeBuilder)booleanValue, ctx);
            return booleanValue.build();
        }
        if (ctx.NullValue() != null) {
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue.Builder stringValue = StringValue.newStringValue().value(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.addCommonData((NodeBuilder)stringValue, ctx);
            return stringValue.build();
        }
        if (ctx.enumValue() != null) {
            EnumValue.Builder enumValue = EnumValue.newEnumValue().name(ctx.enumValue().getText());
            this.addCommonData((NodeBuilder)enumValue, ctx);
            return enumValue.build();
        }
        if (ctx.arrayValueWithVariable() != null) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            this.addCommonData((NodeBuilder)arrayValue, ctx);
            ArrayList<Value> values = new ArrayList<Value>();
            for (StitchingDSLParser.ValueWithVariableContext valueWithVariableContext : ctx.arrayValueWithVariable().valueWithVariable()) {
                values.add(this.createValue(valueWithVariableContext));
            }
            return arrayValue.values(values).build();
        }
        if (ctx.objectValueWithVariable() != null) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            this.addCommonData((NodeBuilder)objectValue, ctx);
            ArrayList<ObjectField> objectFields = new ArrayList<ObjectField>();
            for (StitchingDSLParser.ObjectFieldWithVariableContext objectFieldWithVariableContext : ctx.objectValueWithVariable().objectFieldWithVariable()) {
                ObjectField objectField = ObjectField.newObjectField().name(objectFieldWithVariableContext.name().getText()).value(this.createValue(objectFieldWithVariableContext.valueWithVariable())).build();
                objectFields.add(objectField);
            }
            return objectValue.objectFields(objectFields).build();
        }
        if (ctx.variable() != null) {
            VariableReference.Builder variableReference = VariableReference.newVariableReference().name(ctx.variable().name().getText());
            this.addCommonData((NodeBuilder)variableReference, ctx);
            return variableReference.build();
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    protected Value createValue(StitchingDSLParser.ValueContext ctx) {
        if (ctx.IntValue() != null) {
            IntValue.Builder intValue = IntValue.newIntValue().value(new BigInteger(ctx.IntValue().getText()));
            this.addCommonData((NodeBuilder)intValue, ctx);
            return intValue.build();
        }
        if (ctx.FloatValue() != null) {
            FloatValue.Builder floatValue = FloatValue.newFloatValue().value(new BigDecimal(ctx.FloatValue().getText()));
            this.addCommonData((NodeBuilder)floatValue, ctx);
            return floatValue.build();
        }
        if (ctx.BooleanValue() != null) {
            BooleanValue.Builder booleanValue = BooleanValue.newBooleanValue().value(Boolean.parseBoolean(ctx.BooleanValue().getText()));
            this.addCommonData((NodeBuilder)booleanValue, ctx);
            return booleanValue.build();
        }
        if (ctx.NullValue() != null) {
            return NullValue.Null;
        }
        if (ctx.stringValue() != null) {
            StringValue.Builder stringValue = StringValue.newStringValue().value(GraphqlAntlrToLanguage.quotedString(ctx.stringValue()));
            this.addCommonData((NodeBuilder)stringValue, ctx);
            return stringValue.build();
        }
        if (ctx.enumValue() != null) {
            EnumValue.Builder enumValue = EnumValue.newEnumValue().name(ctx.enumValue().getText());
            this.addCommonData((NodeBuilder)enumValue, ctx);
            return enumValue.build();
        }
        if (ctx.arrayValue() != null) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            this.addCommonData((NodeBuilder)arrayValue, ctx);
            ArrayList<Value> values = new ArrayList<Value>();
            for (StitchingDSLParser.ValueContext valueContext : ctx.arrayValue().value()) {
                values.add(this.createValue(valueContext));
            }
            return arrayValue.values(values).build();
        }
        if (ctx.objectValue() != null) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            this.addCommonData((NodeBuilder)objectValue, ctx);
            ArrayList<ObjectField> objectFields = new ArrayList<ObjectField>();
            for (StitchingDSLParser.ObjectFieldContext objectFieldContext : ctx.objectValue().objectField()) {
                ObjectField objectField = ObjectField.newObjectField().name(objectFieldContext.name().getText()).value(this.createValue(objectFieldContext.value())).build();
                objectFields.add(objectField);
            }
            return objectValue.objectFields(objectFields).build();
        }
        return (Value)Assert.assertShouldNeverHappen();
    }

    static String quotedString(StitchingDSLParser.StringValueContext ctx) {
        boolean multiLine = ctx.TripleQuotedStringValue() != null;
        String strText = ctx.getText();
        if (multiLine) {
            return StringValueParsing.parseTripleQuotedString((String)strText);
        }
        return StringValueParsing.parseSingleQuotedString((String)strText);
    }

    protected void addCommonData(NodeBuilder nodeBuilder, ParserRuleContext parserRuleContext) {
        List<Comment> comments = this.getComments(parserRuleContext);
        if (!comments.isEmpty()) {
            nodeBuilder.comments(comments);
        }
        nodeBuilder.sourceLocation(this.getSourceLocation(parserRuleContext));
    }

    protected Description newDescription(StitchingDSLParser.DescriptionContext descriptionCtx) {
        if (descriptionCtx == null) {
            return null;
        }
        StitchingDSLParser.StringValueContext stringValueCtx = descriptionCtx.stringValue();
        if (stringValueCtx == null) {
            return null;
        }
        boolean multiLine = stringValueCtx.TripleQuotedStringValue() != null;
        String content = stringValueCtx.getText();
        content = multiLine ? StringValueParsing.parseTripleQuotedString((String)content) : StringValueParsing.parseSingleQuotedString((String)content);
        SourceLocation sourceLocation = this.getSourceLocation(descriptionCtx);
        return new Description(content, sourceLocation, multiLine);
    }

    protected SourceLocation getSourceLocation(ParserRuleContext parserRuleContext) {
        Token startToken = parserRuleContext.getStart();
        String sourceName = startToken.getTokenSource().getSourceName();
        if ("<unknown>".equals(sourceName)) {
            sourceName = null;
        }
        return new SourceLocation(startToken.getLine(), startToken.getCharPositionInLine() + 1, sourceName);
    }

    protected List<Comment> getComments(ParserRuleContext ctx) {
        int tokPos;
        List refChannel;
        Token start = ctx.getStart();
        if (start != null && (refChannel = this.tokens.getHiddenTokensToLeft(tokPos = start.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(refChannel);
        }
        return Collections.emptyList();
    }

    protected List<Comment> getCommentOnChannel(List<Token> refChannel) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Token refTok : refChannel) {
            String text = refTok.getText();
            if (text == null) continue;
            text = text.replaceFirst("^#", "");
            comments.add(new Comment(text, new SourceLocation(refTok.getLine(), refTok.getCharPositionInLine())));
        }
        return comments;
    }
}

