/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.voyager.boot;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class VoyagerController {
    @Value(value="${voyager.endpoint:/graphql}")
    private String graphqlEndpoint;
    @Value(value="${voyager.pageTitle:Voyager}")
    private String pageTitle;

    @RequestMapping(value={"${voyager.mapping:/voyager}"})
    public void voyager(HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        String template = StreamUtils.copyToString((InputStream)new ClassPathResource("voyager.html").getInputStream(), (Charset)Charset.defaultCharset());
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("graphqlEndpoint", this.graphqlEndpoint);
        replacements.put("pageTitle", this.pageTitle);
        response.getOutputStream().write(StrSubstitutor.replace((Object)template, replacements).getBytes(Charset.defaultCharset()));
    }
}

