/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractQuery;
import com.groupbyinc.api.model.MatchStrategy;
import com.groupbyinc.api.model.PartialMatchRule;
import com.groupbyinc.api.request.AbstractRequest;
import com.groupbyinc.api.request.RefinementsRequest;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.api.request.Sort;
import com.groupbyinc.common.util.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class Query
extends AbstractQuery<Request, Query> {
    private List<com.groupbyinc.api.model.Sort> sort = new ArrayList<com.groupbyinc.api.model.Sort>();
    private MatchStrategy matchStrategy;
    private boolean wildcardSearchEnabled;

    protected static com.groupbyinc.api.request.MatchStrategy convertPartialMatchStrategy(MatchStrategy strategy) {
        com.groupbyinc.api.request.MatchStrategy convertedStrategy = null;
        if (strategy != null && CollectionUtils.isNotEmpty(strategy.getRules())) {
            convertedStrategy = new com.groupbyinc.api.request.MatchStrategy();
            for (PartialMatchRule r : strategy.getRules()) {
                convertedStrategy.getRules().add(Query.convertPartialMatchRule(r));
            }
        }
        return convertedStrategy;
    }

    protected static com.groupbyinc.api.request.PartialMatchRule convertPartialMatchRule(PartialMatchRule rule) {
        return rule == null ? null : new com.groupbyinc.api.request.PartialMatchRule().setTerms(rule.getTerms()).setTermsGreaterThan(rule.getTermsGreaterThan()).setMustMatch(rule.getMustMatch()).setPercentage(rule.getPercentage());
    }

    protected Request generateRequest() {
        Request request = new Request();
        request.setWildcardSearchEnabled(this.isWildcardSearchEnabled());
        if (CollectionUtils.isNotEmpty(this.sort)) {
            for (com.groupbyinc.api.model.Sort s : this.sort) {
                request.setSort(new Sort[]{Query.convertSort((com.groupbyinc.api.model.Sort)s)});
            }
        }
        request.setMatchStrategy(Query.convertPartialMatchStrategy(this.matchStrategy));
        return request;
    }

    protected RefinementsRequest<Request> populateRefinementRequest() {
        return new RefinementsRequest().setOriginalQuery((AbstractRequest)this.generateRequest());
    }

    public boolean isWildcardSearchEnabled() {
        return this.wildcardSearchEnabled;
    }

    public Query setWildcardSearchEnabled(boolean wildcardSearchEnabled) {
        this.wildcardSearchEnabled = wildcardSearchEnabled;
        return this;
    }

    public List<com.groupbyinc.api.model.Sort> getSort() {
        return this.sort;
    }

    public Query setSort(com.groupbyinc.api.model.Sort ... sort) {
        CollectionUtils.addAll(this.sort, (Object[])sort);
        return this;
    }

    public Query setMatchStrategy(MatchStrategy matchStrategy) {
        this.matchStrategy = matchStrategy;
        return this;
    }
}

