/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl;

import com.groupbyinc.common.http.HttpResponse;
import com.groupbyinc.common.http.HttpResponseFactory;
import com.groupbyinc.common.http.ProtocolVersion;
import com.groupbyinc.common.http.ReasonPhraseCatalog;
import com.groupbyinc.common.http.StatusLine;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.impl.EnglishReasonPhraseCatalog;
import com.groupbyinc.common.http.message.BasicHttpResponse;
import com.groupbyinc.common.http.message.BasicStatusLine;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.util.Args;
import java.util.Locale;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

