/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.client;

import com.groupbyinc.common.http.HeaderElement;
import com.groupbyinc.common.http.HttpResponse;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.conn.ConnectionKeepAliveStrategy;
import com.groupbyinc.common.http.message.BasicHeaderElementIterator;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

