/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.protocol;

import com.groupbyinc.common.http.HttpEntity;
import com.groupbyinc.common.http.HttpEntityEnclosingRequest;
import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpRequest;
import com.groupbyinc.common.http.HttpRequestInterceptor;
import com.groupbyinc.common.http.HttpVersion;
import com.groupbyinc.common.http.ProtocolVersion;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

