/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.ser;

import com.groupbyinc.common.jackson.core.JsonGenerator;
import com.groupbyinc.common.jackson.core.SerializableString;
import com.groupbyinc.common.jackson.databind.JsonSerializer;
import com.groupbyinc.common.jackson.databind.SerializerProvider;
import com.groupbyinc.common.jackson.databind.ser.BeanPropertyWriter;
import com.groupbyinc.common.jackson.module.afterburner.ser.BeanPropertyAccessor;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final SerializableString _fastName;
    protected final int _propertyIndex;
    protected final BeanPropertyWriter fallbackWriter;
    protected boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor propertyAccessor, int propertyIndex, JsonSerializer<Object> ser) {
        super(src);
        this.fallbackWriter = this.unwrapFallbackWriter(src);
        this._serializer = ser != null ? ser : src.getSerializer();
        this._propertyAccessor = propertyAccessor;
        this._propertyIndex = propertyIndex;
        this._fastName = src.getSerializedName();
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter srcIn) {
        while (srcIn instanceof OptimizedBeanPropertyWriter) {
            srcIn = ((OptimizedBeanPropertyWriter)srcIn).fallbackWriter;
        }
        return srcIn;
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    @Override
    public abstract void serializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    @Override
    public abstract void serializeAsElement(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    protected synchronized void _handleProblem(Object bean, JsonGenerator gen, SerializerProvider prov, Throwable t, boolean element) throws Exception {
        if (t instanceof IllegalAccessError || t instanceof SecurityException) {
            this._reportProblem(bean, t);
            if (element) {
                this.fallbackWriter.serializeAsElement(bean, gen, prov);
            } else {
                this.fallbackWriter.serializeAsField(bean, gen, prov);
            }
            return;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (Exception)t;
    }

    protected void _reportProblem(Object bean, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Afterburner serialization for type %s, field #%d, due to access error (type %s, message=%s)%n", bean.getClass(), this._propertyIndex, e.getClass().getName(), e.getMessage());
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, msg, e);
    }
}

