/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.model.Bias;
import com.groupbyinc.api.model.Biasing;
import com.groupbyinc.api.model.CustomUrlParam;
import com.groupbyinc.api.model.MatchStrategy;
import com.groupbyinc.api.model.Navigation;
import com.groupbyinc.api.model.PartialMatchRule;
import com.groupbyinc.api.model.Refinement;
import com.groupbyinc.api.model.refinement.RefinementRange;
import com.groupbyinc.api.model.refinement.RefinementValue;
import com.groupbyinc.api.request.Bias;
import com.groupbyinc.api.request.RefinementsRequest;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.api.request.RestrictNavigation;
import com.groupbyinc.api.request.SelectedRefinement;
import com.groupbyinc.api.request.Sort;
import com.groupbyinc.api.request.refinement.SelectedRefinementRange;
import com.groupbyinc.api.request.refinement.SelectedRefinementValue;
import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.jregex.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Query {
    private static final Logger LOG = Logger.getLogger(Query.class.getName());
    public static final Pattern REFINEMENTS_SPLITTER_PATTERN = new Pattern("~((?=[\\w.]*[=:]))");
    public static final String[] EMPTY_REFINEMENTS = new String[0];
    private static final String DOTS = "\\.\\.";
    private List<com.groupbyinc.api.model.Sort> sort = new ArrayList<com.groupbyinc.api.model.Sort>();
    private MatchStrategy matchStrategy;
    private boolean wildcardSearchEnabled;
    private List<String> includedNavigations = new ArrayList<String>();
    private List<String> excludedNavigations = new ArrayList<String>();
    private String userId;
    private String query;
    private int skip = 0;
    private int pageSize = 10;
    private String collection;
    private String area;
    private String biasingProfile;
    private String language;
    private Map<String, String> queryUrlParams = new HashMap<String, String>();
    private List<CustomUrlParam> customUrlParams = new ArrayList<CustomUrlParam>();
    private LinkedHashMap<String, Navigation> navigations = new LinkedHashMap();
    private List<String> fields = new ArrayList<String>();
    private List<String> orFields = new ArrayList<String>();
    private boolean pruneRefinements = true;
    private boolean returnBinary = true;
    private boolean disableAutocorrection = false;
    private RestrictNavigation restrictNavigation;
    private Biasing biasing = new Biasing();

    private static String requestToJson(Request request) {
        try {
            return Mappers.writeValueAsString(request);
        }
        catch (IllegalArgumentException e) {
            return "{}";
        }
    }

    private static String requestToJson(RefinementsRequest request) {
        try {
            return Mappers.writeValueAsString(request);
        }
        catch (IllegalArgumentException e) {
            return "{}";
        }
    }

    protected static Sort convertSort(com.groupbyinc.api.model.Sort sort) {
        Sort convertedSort = null;
        if (sort != null) {
            convertedSort = new Sort().setField(sort.getField());
            switch (sort.getOrder()) {
                case Ascending: {
                    convertedSort.setOrder(Sort.Order.Ascending);
                    break;
                }
                case Descending: {
                    convertedSort.setOrder(Sort.Order.Descending);
                }
            }
        }
        return convertedSort;
    }

    private List<SelectedRefinement> generateSelectedRefinements(LinkedHashMap<String, Navigation> navigations) {
        ArrayList<SelectedRefinement> refinements = new ArrayList<SelectedRefinement>();
        for (Navigation n : navigations.values()) {
            for (Refinement r : n.getRefinements()) {
                switch (r.getType()) {
                    case Range: {
                        RefinementRange rr = (RefinementRange)r;
                        refinements.add((SelectedRefinement)((SelectedRefinementRange)new SelectedRefinementRange().setNavigationName(n.getName())).setLow(rr.getLow()).setHigh(rr.getHigh()).setExclude(rr.getExclude()));
                        break;
                    }
                    case Value: {
                        RefinementValue rv = (RefinementValue)r;
                        refinements.add((SelectedRefinement)((SelectedRefinementValue)new SelectedRefinementValue().setNavigationName(n.getName())).setValue(rv.getValue()).setExclude(rv.getExclude()));
                        break;
                    }
                }
            }
        }
        return refinements;
    }

    protected static com.groupbyinc.api.request.PartialMatchRule convertPartialMatchRule(PartialMatchRule rule) {
        return rule == null ? null : new com.groupbyinc.api.request.PartialMatchRule().setTerms(rule.getTerms()).setTermsGreaterThan(rule.getTermsGreaterThan()).setMustMatch(rule.getMustMatch()).setPercentage(rule.getPercentage());
    }

    private Request populateRequest(String clientKey) {
        Request request = new Request();
        request.setUserId(this.userId);
        request.setIncludedNavigations(this.includedNavigations);
        request.setExcludedNavigations(this.excludedNavigations);
        request.setClientKey(clientKey);
        request.setArea(this.area);
        request.setCollection(this.collection);
        request.setQuery(this.query);
        request.setFields(this.fields);
        request.setOrFields(this.orFields);
        request.setLanguage(this.language);
        request.setBiasingProfile(this.biasingProfile);
        request.setPageSize(this.pageSize);
        request.setSkip(this.skip);
        request.setBiasing(Query.convertBiasing(this.biasing));
        request.setCustomUrlParams(this.getCustomUrlParams());
        request.setRefinements(this.generateSelectedRefinements(this.navigations));
        request.setRestrictNavigation(this.convertRestrictNavigation());
        request.setWildcardSearchEnabled(this.isWildcardSearchEnabled());
        if (CollectionUtils.isNotEmpty(this.sort)) {
            for (com.groupbyinc.api.model.Sort s : this.sort) {
                request.setSort(Query.convertSort(s));
            }
        }
        request.setMatchStrategy(Query.convertPartialMatchStrategy(this.matchStrategy));
        if (!this.pruneRefinements) {
            request.setPruneRefinements(false);
        }
        if (this.returnBinary) {
            request.setReturnBinary(true);
        }
        if (this.disableAutocorrection) {
            request.setDisableAutocorrection(true);
        }
        return request;
    }

    private RestrictNavigation convertRestrictNavigation() {
        return this.restrictNavigation == null ? null : new RestrictNavigation().setName(this.restrictNavigation.getName()).setCount(this.restrictNavigation.getCount());
    }

    public String getBridgeJson(String clientKey) {
        return Query.requestToJson(this.populateRequest(clientKey));
    }

    public String getBridgeRefinementsJson(String clientKey, String navigationName) {
        RefinementsRequest request = new RefinementsRequest();
        request.setOriginalQuery(this.populateRequest(clientKey));
        request.setNavigationName(navigationName);
        return Query.requestToJson(request);
    }

    public String getQuery() {
        return this.query;
    }

    public Query setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getSubCollection() {
        return this.collection;
    }

    public Query setSubCollection(String subCollection) {
        this.collection = subCollection;
        return this;
    }

    public String getCollection() {
        return this.collection;
    }

    public Query setCollection(String collection) {
        this.collection = collection;
        return this;
    }

    public String getArea() {
        return this.area;
    }

    public Query setArea(String area) {
        this.area = area;
        return this;
    }

    public String getRefinementString() {
        if (CollectionUtils.isNotEmpty(this.navigations.values())) {
            StringBuilder result = new StringBuilder();
            for (Navigation n : this.navigations.values()) {
                for (Refinement r : n.getRefinements()) {
                    result.append("~").append(n.getName()).append(r.toTildeString());
                }
            }
            if (result.length() > 0) {
                return result.toString();
            }
        }
        return null;
    }

    public String getCustomUrlParamsString() {
        if (CollectionUtils.isEmpty(this.customUrlParams)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (CustomUrlParam customUrlParam : this.customUrlParams) {
            result.append("~").append(customUrlParam.getKey()).append("=").append(customUrlParam.getValue());
        }
        return result.toString();
    }

    public List<CustomUrlParam> getCustomUrlParams() {
        return this.customUrlParams;
    }

    protected String getBridgeJsonRefinementSearch(String clientKey) {
        Request request = new Request();
        request.setIncludedNavigations(this.includedNavigations);
        request.setExcludedNavigations(this.excludedNavigations);
        request.setClientKey(clientKey);
        request.setCollection(this.collection);
        request.setArea(this.area);
        request.setRefinementQuery(this.query);
        request.setWildcardSearchEnabled(this.isWildcardSearchEnabled());
        if (CollectionUtils.isNotEmpty(this.sort)) {
            for (com.groupbyinc.api.model.Sort s : this.sort) {
                request.setSort(Query.convertSort(s));
            }
        }
        request.setMatchStrategy(Query.convertPartialMatchStrategy(this.matchStrategy));
        return Query.requestToJson(request);
    }

    protected String[] splitRefinements(String refinementString) {
        return StringUtils.isBlank(refinementString) ? EMPTY_REFINEMENTS : REFINEMENTS_SPLITTER_PATTERN.tokenizer(refinementString).split();
    }

    public Query addRefinementsByString(String refinementString) {
        String[] filterStrings;
        if (refinementString == null) {
            return this;
        }
        for (String filterString : filterStrings = this.splitRefinements(refinementString)) {
            Refinement refinement;
            if (StringUtils.isBlank(filterString) || "=".equals(filterString)) continue;
            int colon = filterString.indexOf(":");
            int equals = filterString.indexOf("=");
            boolean isRange = colon != -1 && equals == -1;
            String[] nameValue = filterString.split("[:=]", 2);
            if (isRange) {
                RefinementRange rr = new RefinementRange();
                if (nameValue[1].endsWith("..")) {
                    rr.setLow(nameValue[1].split(DOTS)[0]);
                    rr.setHigh("");
                } else if (nameValue[1].startsWith("..")) {
                    rr.setLow("");
                    rr.setHigh(nameValue[1].split(DOTS)[1]);
                } else {
                    String[] lowHigh = nameValue[1].split(DOTS);
                    rr.setLow(lowHigh[0]);
                    rr.setHigh(lowHigh[1]);
                }
                refinement = rr;
            } else {
                refinement = new RefinementValue();
                refinement.setValue(nameValue[1]);
            }
            if (!StringUtils.isNotBlank(nameValue[0])) continue;
            this.addRefinement(nameValue[0], refinement);
        }
        return this;
    }

    public Query addCustomUrlParam(CustomUrlParam customUrlParam) {
        this.customUrlParams.add(customUrlParam);
        return this;
    }

    public Query addCustomUrlParam(String key, String value) {
        this.customUrlParams.add(new CustomUrlParam().setKey(key).setValue(value));
        return this;
    }

    public Query addCustomUrlParamsByString(String values) {
        String[] params;
        if (values == null) {
            return this;
        }
        for (String value : params = values.split("&")) {
            String[] keyValue;
            if (!StringUtils.isNotBlank(value) || (keyValue = value.split("=")).length != 2 || !StringUtils.isNotBlank(keyValue[0]) || !StringUtils.isNotBlank(keyValue[1])) continue;
            this.customUrlParams.add(new CustomUrlParam().setKey(keyValue[0]).setValue(keyValue[1]));
        }
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    protected Query addField(List<String> fields, String ... name) {
        if (name == null) {
            return this;
        }
        Collections.addAll(fields, name);
        return this;
    }

    public Query addFields(String ... name) {
        return this.addField(this.fields, name);
    }

    public List<String> getOrFields() {
        return this.orFields;
    }

    public Query addOrField(String ... name) {
        return this.addField(this.orFields, name);
    }

    public Query addRangeRefinement(String navigationName, String low, String high) {
        return this.addRangeRefinement(navigationName, low, high, false);
    }

    public Query addRangeRefinement(String navigationName, String low, String high, boolean exclude) {
        return this.addRefinement(navigationName, (Refinement)new RefinementRange().setLow(low).setHigh(high).setExclude(exclude));
    }

    public Query addValueRefinement(String navigationName, String value) {
        return this.addValueRefinement(navigationName, value, false);
    }

    public Query addValueRefinement(String navigationName, String value, boolean exclude) {
        return this.addRefinement(navigationName, (Refinement)new RefinementValue().setValue(value).setExclude(exclude));
    }

    private Query addRefinement(String navigationName, Refinement refinement) {
        Navigation navigation = this.navigations.get(navigationName);
        if (navigation == null) {
            navigation = new Navigation().setName(navigationName);
            navigation.setRange(refinement instanceof RefinementRange);
            this.navigations.put(navigationName, navigation);
        }
        navigation.getRefinements().add(refinement);
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public Query setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public Query setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Map<String, Navigation> getNavigations() {
        return this.navigations;
    }

    public boolean isReturnBinary() {
        return this.returnBinary;
    }

    public Query setReturnBinary(boolean returnBinary) {
        this.returnBinary = returnBinary;
        return this;
    }

    public String getBiasingProfile() {
        return this.biasingProfile;
    }

    public Query setBiasingProfile(String biasingProfile) {
        this.biasingProfile = biasingProfile;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public Query setLanguage(String language) {
        this.language = language;
        return this;
    }

    public boolean isPruneRefinements() {
        return this.pruneRefinements;
    }

    public Query setPruneRefinements(boolean pruneRefinements) {
        this.pruneRefinements = pruneRefinements;
        return this;
    }

    public boolean isAutocorrectionDisabled() {
        return this.disableAutocorrection;
    }

    public Query setDisableAutocorrection(boolean disableAutocorrection) {
        this.disableAutocorrection = disableAutocorrection;
        return this;
    }

    public Query setRestrictNavigation(RestrictNavigation restrictNavigation) {
        this.restrictNavigation = restrictNavigation;
        return this;
    }

    public Query setRestrictNavigation(String name, int count) {
        this.restrictNavigation = new RestrictNavigation().setName(name).setCount(count);
        return this;
    }

    protected static com.groupbyinc.api.request.MatchStrategy convertPartialMatchStrategy(MatchStrategy strategy) {
        com.groupbyinc.api.request.MatchStrategy convertedStrategy = null;
        if (strategy != null && CollectionUtils.isNotEmpty(strategy.getRules())) {
            convertedStrategy = new com.groupbyinc.api.request.MatchStrategy();
            for (PartialMatchRule r : strategy.getRules()) {
                convertedStrategy.getRules().add(Query.convertPartialMatchRule(r));
            }
        }
        return convertedStrategy;
    }

    public boolean isWildcardSearchEnabled() {
        return this.wildcardSearchEnabled;
    }

    public Query setWildcardSearchEnabled(boolean wildcardSearchEnabled) {
        this.wildcardSearchEnabled = wildcardSearchEnabled;
        return this;
    }

    public List<com.groupbyinc.api.model.Sort> getSort() {
        return this.sort;
    }

    public Query setSort(com.groupbyinc.api.model.Sort ... sort) {
        CollectionUtils.addAll(this.sort, sort);
        return this;
    }

    public Query setMatchStrategy(MatchStrategy matchStrategy) {
        this.matchStrategy = matchStrategy;
        return this;
    }

    public List<String> getIncludeNavigations() {
        return this.includedNavigations;
    }

    public Query addIncludedNavigations(String ... navigationName) {
        return this.addField(this.includedNavigations, navigationName);
    }

    public List<String> getExcludeNavigations() {
        return this.excludedNavigations;
    }

    public Query addExcludedNavigations(String ... navigationName) {
        return this.addField(this.excludedNavigations, navigationName);
    }

    public Map<String, String> getQueryUrlParams() {
        return this.queryUrlParams;
    }

    public Query setQueryUrlParams(Map<String, String> queryUrlParams) {
        this.queryUrlParams = queryUrlParams;
        return this;
    }

    public Query addQueryUrlParams(String key) {
        return this.addQueryUrlParams(key, null);
    }

    public Query addQueryUrlParams(String key, String value) {
        this.queryUrlParams.put(key, value);
        return this;
    }

    private static Bias.Strength convertStrength(Bias.Strength strength) {
        Bias.Strength convertedStrength;
        try {
            convertedStrength = Bias.Strength.valueOf(strength.name());
        }
        catch (IllegalArgumentException e) {
            LOG.warning("Could not convert bias strength: " + strength.name());
            convertedStrength = Bias.Strength.Leave_Unchanged;
        }
        return convertedStrength;
    }

    private static com.groupbyinc.api.request.Bias convertBias(Bias bias) {
        return new com.groupbyinc.api.request.Bias().setName(bias.getName()).setContent(bias.getContent()).setStrength(Query.convertStrength(bias.getStrength()));
    }

    private static List<com.groupbyinc.api.request.Bias> convertBiases(List<Bias> biases) {
        ArrayList<com.groupbyinc.api.request.Bias> convertedBiases = new ArrayList<com.groupbyinc.api.request.Bias>();
        for (Bias bias : biases) {
            convertedBiases.add(Query.convertBias(bias));
        }
        return convertedBiases;
    }

    protected static com.groupbyinc.api.request.Biasing convertBiasing(Biasing biasing) {
        com.groupbyinc.api.request.Biasing convertedBiasing = new com.groupbyinc.api.request.Biasing();
        boolean hasData = false;
        if (biasing != null) {
            if (CollectionUtils.isNotEmpty(biasing.getBringToTop())) {
                convertedBiasing.setBringToTop(new ArrayList<String>(biasing.getBringToTop()));
                hasData = true;
            }
            if (CollectionUtils.isNotEmpty(biasing.getBiases())) {
                convertedBiasing.setBiases(new ArrayList<com.groupbyinc.api.request.Bias>(Query.convertBiases(biasing.getBiases())));
                convertedBiasing.setAugmentBiases(biasing.isAugmentBiases());
                hasData = true;
            }
            if (biasing.getInfluence() != null) {
                convertedBiasing.setInfluence(biasing.getInfluence());
                hasData = true;
            }
        }
        return hasData ? convertedBiasing : null;
    }

    public Query setBiasing(Biasing biasing) {
        this.biasing = biasing;
        return this;
    }

    public Query setBringToTop(String ... bringToTop) {
        CollectionUtils.addAll(this.biasing.getBringToTop(), bringToTop);
        return this;
    }

    public Query setBiasingAugment(boolean augment) {
        this.biasing.setAugmentBiases(augment);
        return this;
    }

    public Query setInfluence(Float influence) {
        this.biasing.setInfluence(influence);
        return this;
    }

    public Query addBias(String name, String value, Bias.Strength strength) {
        this.biasing.getBiases().add(new Bias().setName(name).setContent(value).setStrength(strength));
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public Query setUserId(String userId) {
        this.userId = userId;
        return this;
    }
}

