/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.commons.collections4.iterators;

import com.groupbyinc.common.apache.commons.collections4.ResettableIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIterator<E>
implements ResettableIterator<E> {
    private final boolean removeAllowed;
    private boolean beforeFirst = true;
    private boolean removed = false;
    private E object;

    public SingletonIterator(E object) {
        this(object, true);
    }

    public SingletonIterator(E object, boolean removeAllowed) {
        this.object = object;
        this.removeAllowed = removeAllowed;
    }

    @Override
    public boolean hasNext() {
        return this.beforeFirst && !this.removed;
    }

    @Override
    public E next() {
        if (!this.beforeFirst || this.removed) {
            throw new NoSuchElementException();
        }
        this.beforeFirst = false;
        return this.object;
    }

    @Override
    public void remove() {
        if (this.removeAllowed) {
            if (this.removed || this.beforeFirst) {
                throw new IllegalStateException();
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.object = null;
        this.removed = true;
    }

    @Override
    public void reset() {
        this.beforeFirst = true;
    }
}

