/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import com.groupbyinc.common.apache.commons.io.IOUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.util.exception.GroupByUtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String ERROR_MSG_RESOURCE_PATH_BLANK = "Unable to read resource, resource name cannot be empty";
    private static final String TEMP_FILENAME_PREFIX = "jvmTempFile_";

    private ResourceUtils() {
    }

    public static URL getUrl(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        return ResourceUtils.class.getResource(resourcePath);
    }

    public static String getPath(String resourcePath) {
        return ResourceUtils.getUrl(resourcePath).getPath();
    }

    public static File getAsFile(String resourcePath) {
        return new File(ResourceUtils.getUrl(resourcePath).getPath());
    }

    public static File copyResourceToTempFile(String resourcePath) {
        FileOutputStream fileOutputStream;
        File file;
        LOG.trace("Copying resource [{}] into temporary file", (Object)resourcePath);
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        try {
            file = File.createTempFile(TEMP_FILENAME_PREFIX, null);
        }
        catch (IOException e) {
            LOG.error("Unable to create temp file on filesystem, check that you have write access", (Throwable)e);
            throw new GroupByUtilException("Unable to create temp file on filesystem, check that you have write access", e);
        }
        LOG.debug("Reading resource [{}] and writing to temporary file: {}", (Object)resourcePath, (Object)file.getAbsolutePath());
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException(e.getMessage(), e);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ResourceUtils.pipeResourceIntoBufferedOutputStream(resourcePath, bufferedOutputStream);
        IOUtils.closeQuietly(bufferedOutputStream);
        IOUtils.closeQuietly(fileOutputStream);
        return file;
    }

    public static String readResourceIntoString(String resourcePath) {
        LOG.trace("Reading resource [{}] into memory (String)", (Object)resourcePath);
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        ResourceUtils.pipeResourceIntoBufferedWriter(resourcePath, bufferedWriter);
        IOUtils.closeQuietly(bufferedWriter);
        IOUtils.closeQuietly(stringWriter);
        return stringWriter.toString();
    }

    public static BufferedReader readResourceIntoBufferedReader(String resourcePath) {
        InputStream resourceInputStream = ResourceUtils.readResourceIntoInputStream(resourcePath);
        InputStreamReader inputStreamReader = new InputStreamReader(resourceInputStream, StandardCharsets.UTF_8);
        return new BufferedReader(inputStreamReader);
    }

    public static BufferedInputStream readResourceIntoBufferedInputStream(String resourcePath) {
        InputStream resourceInputStream = ResourceUtils.readResourceIntoInputStream(resourcePath);
        return new BufferedInputStream(resourceInputStream);
    }

    public static void pipeResourceIntoBufferedWriter(String resourcePath, BufferedWriter bufferedWriter) {
        BufferedReader bufferedReader = ResourceUtils.readResourceIntoBufferedReader(resourcePath);
        try {
            ResourceUtils.pipe(bufferedReader, bufferedWriter);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException("Exception occurred while piping input into output", e);
        }
        finally {
            IOUtils.closeQuietly(bufferedReader);
        }
    }

    public static void pipeResourceIntoBufferedOutputStream(String resourcePath, BufferedOutputStream bufferedOutputStream) {
        BufferedInputStream bufferedInputStream = ResourceUtils.readResourceIntoBufferedInputStream(resourcePath);
        try {
            ResourceUtils.pipe(bufferedInputStream, bufferedOutputStream);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException("Exception occurred while piping input into output", e);
        }
        finally {
            IOUtils.closeQuietly(bufferedInputStream);
        }
    }

    public static InputStream readResourceIntoInputStream(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        InputStream resourceInputStream = ResourceUtils.class.getResourceAsStream(resourcePath);
        if (resourceInputStream == null) {
            String errorMessage = "Unable to read resource into input stream, please check that resource exists";
            LOG.error("{}: {}", (Object)errorMessage, (Object)resourcePath);
            throw new IllegalArgumentException(errorMessage);
        }
        return resourceInputStream;
    }

    private static void pipe(BufferedReader input, BufferedWriter output) throws IOException {
        int character;
        while ((character = input.read()) != -1) {
            output.write(character);
        }
        output.flush();
    }

    private static void pipe(BufferedInputStream input, BufferedOutputStream output) throws IOException {
        int character;
        while ((character = input.read()) != -1) {
            output.write(character);
        }
        output.flush();
    }
}

