/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.util;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.util.UrlReplacement;
import java.util.List;

public class UrlReplacementRule {
    private String target;
    private String replacement;
    private String navigationName;
    public static final String INSERT_INDICATOR = "i";
    public static final String REPLACEMENT_DELIMITER = "-";

    public UrlReplacementRule(char target, Character replacement, String navigationName) {
        this.target = Character.toString(target);
        this.replacement = replacement == null ? "" : replacement.toString();
        this.navigationName = navigationName;
    }

    public void apply(StringBuilder url, int indexOffSet, String navigationName, List<UrlReplacement> replacementBuilder) {
        if (url != null && (this.navigationName == null || navigationName.equals(this.navigationName))) {
            int index = url.indexOf(this.target);
            while (index != -1) {
                UrlReplacement.OperationType type = UrlReplacement.OperationType.Swap;
                if (StringUtils.isEmpty(this.replacement)) {
                    this.replacement = "";
                    type = UrlReplacement.OperationType.Insert;
                    url.deleteCharAt(index);
                } else {
                    url.replace(index, index + this.replacement.length(), this.replacement);
                }
                UrlReplacement replacement = new UrlReplacement(index + indexOffSet, this.target, type);
                replacementBuilder.add(replacement);
                index = url.indexOf(this.target, index);
            }
        }
    }
}

