package com.groupbyinc.common.util;

import com.groupbyinc.common.util.exception.GroupByUtilException;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Java utilities
 *
 * @author Alan Czajkowski
 */
public final class JavaUtils {

    private JavaUtils() {
        // not publicly instantiable
    }

    /**
     * Return a non-null {@link List}.
     *
     * @param list
     *         a list (can be null)
     *
     * @return {@link List} a non-null immutable list
     */
    public static <T> List<T> notNull(List<T> list) {
        return list == null ? Collections.<T>emptyList() : list;
    }

    /**
     * Return a non-null {@link Set}.
     *
     * @param set
     *         a set (can be null)
     *
     * @return {@link Set} a non-null immutable set
     */
    public static <T> Set<T> notNull(Set<T> set) {
        return set == null ? Collections.<T>emptySet() : set;
    }

    /**
     * Return a non-null {@link Collection}.
     *
     * @param collection
     *         a collection (List or Set, can be null)
     *
     * @return {@link Collection} a non-null immutable collection
     */
    public static <T> Collection<T> notNull(Collection<T> collection) {
        if (collection instanceof List) {
            return notNull((List<T>) collection);
        } else if (collection instanceof Set) {
            return notNull((Set<T>) collection);
        }

        throw new GroupByUtilException("Not a List or Set");
    }

    /**
     * Return a non-null {@link Map}.
     *
     * @param map
     *         a map (can be null)
     *
     * @return {@link Map} a non-null immutable map
     */
    public static <K, V> Map<K, V> notNull(Map<K, V> map) {
        return map == null ? Collections.<K, V>emptyMap() : map;
    }

}
