package com.groupbyinc.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Thread utilities
 *
 * @author Alan Czajkowski
 */
public final class ThreadUtils {

    private static final transient Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    private ThreadUtils() {
        // not publicly instantiable
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException ie) {
            LOG.warn(ie.getMessage(), ie);
        }
    }

}
