/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.util;

import com.groupbyinc.api.parser.ParserException;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UrlReplacement {
    private int index;
    private String replacement;
    private OperationType type;

    public UrlReplacement(int index, String replacement, OperationType type) {
        this.index = index;
        this.replacement = replacement;
        this.type = type;
    }

    public static List<UrlReplacement> parseQueryString(String query) throws ParserException {
        int delimiterIndex = 0;
        ArrayList<UrlReplacement> replacements = new ArrayList<UrlReplacement>();
        if (StringUtils.isBlank(query)) {
            return replacements;
        }
        StringBuilder queryString = new StringBuilder(query);
        while (delimiterIndex >= 0) {
            int pairSeparator = queryString.indexOf("-");
            if (pairSeparator < 0) {
                throw new ParserException("Replacement Query Delimiters did not match up");
            }
            delimiterIndex = queryString.indexOf("-", pairSeparator + 2);
            if (delimiterIndex < 0) break;
            replacements.add(UrlReplacement.fromString(queryString.substring(0, delimiterIndex)));
            queryString.delete(0, delimiterIndex);
            if (!Character.toString(queryString.charAt(0)).equals("-")) continue;
            queryString.deleteCharAt(0);
        }
        if (StringUtils.isNotBlank(query = queryString.toString())) {
            replacements.add(UrlReplacement.fromString(query));
        }
        Collections.reverse(replacements);
        return replacements;
    }

    public static UrlReplacement fromString(String urlReplacementString) throws ParserException {
        OperationType operationType = OperationType.Swap;
        int delimiterIndex = urlReplacementString.indexOf("-");
        if (delimiterIndex < 0) {
            throw new ParserException("Argument did not match expected format: " + urlReplacementString);
        }
        String replacementValue = urlReplacementString.substring(delimiterIndex + 1);
        String indexString = urlReplacementString.substring(0, delimiterIndex);
        if (indexString.startsWith("i")) {
            operationType = OperationType.Insert;
            indexString = indexString.substring(1);
        }
        try {
            int indexValue = Integer.parseInt(indexString);
            return new UrlReplacement(indexValue, replacementValue, operationType);
        }
        catch (NumberFormatException e) {
            throw new ParserException("Invalid index:" + indexString);
        }
    }

    public static String buildQueryString(List<UrlReplacement> replacements) {
        StringBuilder sb = new StringBuilder();
        for (UrlReplacement replacement : replacements) {
            if (sb.length() != 0) {
                sb.append("-");
            }
            sb.append(replacement.toString());
        }
        return sb.toString();
    }

    public void apply(StringBuilder pathSegment, int offSet) {
        int relativeIndex = this.index - offSet;
        if (relativeIndex < 0 || relativeIndex >= pathSegment.length() && this.type.equals((Object)OperationType.Swap) || relativeIndex > pathSegment.length() && this.type.equals((Object)OperationType.Insert)) {
            return;
        }
        if (this.type.equals((Object)OperationType.Insert)) {
            pathSegment.insert(relativeIndex, this.replacement);
        } else if (this.type.equals((Object)OperationType.Swap)) {
            pathSegment.replace(relativeIndex, relativeIndex + this.replacement.length(), this.replacement);
        }
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + (this.replacement != null ? this.replacement.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlReplacement)) {
            return false;
        }
        UrlReplacement other = (UrlReplacement)o;
        if (this.index != other.index || this.type != other.type) {
            return false;
        }
        if (this.replacement == null) {
            return other.replacement == null;
        }
        return this.replacement.equals(other.replacement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type == OperationType.Insert) {
            sb.append("i");
        }
        sb.append(this.index);
        sb.append("-");
        sb.append(this.replacement);
        return sb.toString();
    }

    public static enum OperationType {
        Insert,
        Swap;

    }
}

