/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import com.groupbyinc.common.util.exception.GroupByUtilException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JavaUtils {
    private JavaUtils() {
    }

    public static <T> List<T> notNull(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    public static <T> Set<T> notNull(Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    public static <T> Collection<T> notNull(Collection<T> collection) {
        if (collection instanceof List) {
            return JavaUtils.notNull((List)collection);
        }
        if (collection instanceof Set) {
            return JavaUtils.notNull((Set)collection);
        }
        throw new GroupByUtilException("Not a List or Set");
    }

    public static <K, V> Map<K, V> notNull(Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }
}

