/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.logging;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingContext {
    private static final transient Logger LOG = LoggerFactory.getLogger(LoggingContext.class);
    private static final String UNKNOWN = "<UNKNOWN>";

    public static void init() {
        LOG.debug("initializing all values as '{}'", (Object)UNKNOWN);
        for (Key key : Key.values()) {
            MDC.put((String)key.getValue(), (String)UNKNOWN);
        }
    }

    public static void set(Key key, String value) {
        String keyValue = key.getValue();
        if (StringUtils.isNotBlank(value)) {
            LOG.debug("setting '{}' to '{}'", (Object)keyValue, (Object)value);
            MDC.put((String)keyValue, (String)value);
        } else {
            LOG.debug("'{}' must not be blank", (Object)keyValue);
        }
    }

    public static enum Key {
        CustomerId("customerId");

        String value;

        private Key(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

