package com.groupbyinc.common.util;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by groupby on 09/07/15.
 */
public class DefaultForkJoinWorkerThreadFactory implements ForkJoinPool.ForkJoinWorkerThreadFactory {

  public static class WorkerThread extends ForkJoinWorkerThread {

    protected WorkerThread(ForkJoinPool pool) {
      super(pool);
    }
  }

  private final AtomicInteger threadNumber = new AtomicInteger(0);
  /**
   * ThreadFactory that keeps the current thread's name to make logs easier
   * to follow and grep
   * @return
   */
  private String parent;
  private String name;
  private boolean includeThreadNumber;

  public DefaultForkJoinWorkerThreadFactory(String parent, String name, boolean includeThreadNumber) {
    this.parent = parent;
    this.name = name;
    this.includeThreadNumber = includeThreadNumber;
  }

  @Override
  public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
    ForkJoinWorkerThread t = new WorkerThread(pool);
    StringBuilder overrideName = new StringBuilder();
    overrideName.append(parent);
    overrideName.append(":");
    overrideName.append(name);
    if (includeThreadNumber) {
      overrideName.append(":");
      overrideName.append(threadNumber.incrementAndGet());
    }
    t.setName(overrideName.toString());
    return t;
  }
}

