/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.http.impl.entity;

import com.groupbyinc.common.apache.http.HttpException;
import com.groupbyinc.common.apache.http.HttpMessage;
import com.groupbyinc.common.apache.http.ProtocolException;
import com.groupbyinc.common.apache.http.annotation.Immutable;
import com.groupbyinc.common.apache.http.entity.ContentLengthStrategy;
import com.groupbyinc.common.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

