/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private String name;
    private boolean includeThreadNumber;

    public DefaultThreadFactory(String name, boolean includeThreadNumber) {
        this.name = name;
        this.includeThreadNumber = includeThreadNumber;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.defaultFactory.newThread(r);
        StringBuilder overrideName = new StringBuilder();
        overrideName.append(Thread.currentThread().getName());
        overrideName.append(":");
        overrideName.append(this.name);
        if (this.includeThreadNumber) {
            overrideName.append(":");
            overrideName.append(this.threadNumber.incrementAndGet());
        }
        t.setName(overrideName.toString());
        return t;
    }
}

