/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.util.exception.ValidationException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;

public class ValidatorUtil {
    private static final String ERR_OBJECT_IS_NULL = "Internal error";

    public static <T> void validate(Validator validator, T object) throws ValidationException {
        if (object == null) {
            throw new ValidationException(new String[]{ERR_OBJECT_IS_NULL});
        }
        Set errors = validator.validate(object, new Class[0]);
        if (CollectionUtils.isNotEmpty(errors)) {
            throw new ValidationException(errors.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList()));
        }
    }
}

