/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.Query;
import com.groupbyinc.api.config.ConnectionConfiguration;
import com.groupbyinc.api.model.RefinementsResult;
import com.groupbyinc.api.model.Results;
import com.groupbyinc.api.request.RefinementsRequest;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.common.apache.commons.collections4.MapUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.apache.http.ConnectionClosedException;
import com.groupbyinc.common.apache.http.Header;
import com.groupbyinc.common.apache.http.HttpEntity;
import com.groupbyinc.common.apache.http.NoHttpResponseException;
import com.groupbyinc.common.apache.http.StatusLine;
import com.groupbyinc.common.apache.http.client.config.RequestConfig;
import com.groupbyinc.common.apache.http.client.methods.CloseableHttpResponse;
import com.groupbyinc.common.apache.http.client.methods.HttpPost;
import com.groupbyinc.common.apache.http.client.utils.URIBuilder;
import com.groupbyinc.common.apache.http.entity.StringEntity;
import com.groupbyinc.common.apache.http.impl.client.CloseableHttpClient;
import com.groupbyinc.common.apache.http.impl.client.HttpClientBuilder;
import com.groupbyinc.common.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.groupbyinc.common.apache.http.util.EntityUtils;
import com.groupbyinc.common.jackson.Mappers;
import com.groupbyinc.common.security.AesContent;
import com.groupbyinc.common.security.AesEncryption;
import com.groupbyinc.common.util.ThreadUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractBridge {
    public static final int DEFAULT_RETRY_TIMEOUT = 80;
    public static final int DEFAULT_MAX_TRIES = 3;
    public static final String CLUSTER = "/cluster";
    protected static final String COLON = ":";
    protected static final String HTTP = "http://";
    protected static final String HTTPS = "https://";
    private static final Logger LOG = Logger.getLogger(AbstractBridge.class.getName());
    private static final String SEARCH = "/search";
    private static final String REFINEMENTS = "/refinements";
    private static final String BODY = "\nbody:\n";
    private static final String EXCEPTION_FROM_BRIDGE = "Exception from bridge: ";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ConnectionConfiguration config;
    private final RequestConfig requestConfig;
    private final String bridgeUrl;
    private final String bridgeRefinementsUrl;
    private final String bridgeClusterUrl;
    protected String clientKey;
    private CloseableHttpClient httpClient;
    private long retryTimeout = 80L;
    private long maxTries = 3L;
    private volatile List<Header> headers = new ArrayList<Header>();

    public AbstractBridge(String clientKey, String baseUrl) {
        this(clientKey, baseUrl, true, new ConnectionConfiguration());
    }

    public AbstractBridge(String clientKey, String baseUrl, boolean compressResponse, ConnectionConfiguration config) {
        try {
            new URI(baseUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid url: " + baseUrl);
        }
        this.config = config;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnectTimeout()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).setSocketTimeout(config.getSocketTimeout()).build();
        this.clientKey = clientKey;
        this.createClient(compressResponse);
        this.bridgeUrl = baseUrl + SEARCH;
        this.bridgeRefinementsUrl = this.bridgeUrl + REFINEMENTS;
        this.bridgeClusterUrl = baseUrl + CLUSTER;
    }

    private void createClient(boolean compressResponse) {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.config.getMaxConnections());
        cm.setDefaultMaxPerRoute(this.config.getMaxConnectionsPerRoute());
        HttpClientBuilder b = HttpClientBuilder.create();
        if (!compressResponse) {
            b.disableContentCompression();
        }
        this.httpClient = b.setConnectionManager(cm).setDefaultRequestConfig(this.requestConfig).build();
    }

    public AbstractBridge(String clientKey, String baseUrl, ConnectionConfiguration config) {
        this(clientKey, baseUrl, true, config);
    }

    public AbstractBridge(String clientKey, String baseUrl, boolean compressResponse) {
        this(clientKey, baseUrl, compressResponse, new ConnectionConfiguration());
    }

    public String getClusterBridgeUrl() {
        return this.bridgeClusterUrl;
    }

    public Results search(Query query) throws IOException {
        InputStream data = this.fireRequest(this.getBridgeUrl(), query.getQueryUrlParams(), query.getBridgeJson(this.clientKey), query.isReturnBinary());
        return this.map(data, query.isReturnBinary());
    }

    protected InputStream fireRequest(String url, Map<String, String> urlParams, String body, boolean returnBinary) throws IOException {
        CloseableHttpResponse response = this.postToBridge(url, urlParams, body);
        HttpEntity entity = response.getEntity();
        if (response.getStatusLine().getStatusCode() == 200) {
            return entity.getContent();
        }
        String status = response.getStatusLine().toString();
        this.handleErrorStatus(status, EntityUtils.toByteArray(entity), returnBinary);
        return null;
    }

    public String getBridgeUrl() {
        return this.bridgeUrl;
    }

    protected Results map(InputStream data, boolean returnBinary) {
        return Mappers.readValue(data, Results.class, returnBinary);
    }

    private CloseableHttpResponse postToBridge(String url, Map<String, String> urlParams, String bridgeJson) throws IOException {
        StringEntity entity = new StringEntity(bridgeJson, UTF_8);
        entity.setContentType("application/json");
        CloseableHttpResponse response = null;
        boolean successful = false;
        int tries = 0;
        IOException lastError = null;
        while (!successful && (long)tries < this.maxTries) {
            try {
                HttpPost httpPost = new HttpPost(this.generateURI(url, urlParams, tries));
                for (Header header : this.headers) {
                    httpPost.addHeader(header);
                }
                httpPost.setEntity(entity);
                response = this.httpClient.execute(httpPost);
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() == 502) {
                    ThreadUtils.sleep(this.retryTimeout);
                    LOG.warning("Connection failed, retrying");
                    lastError = new IOException(statusLine.getReasonPhrase());
                    ++tries;
                    continue;
                }
                successful = true;
            }
            catch (URISyntaxException e) {
                LOG.severe("Invalid request, failing");
                break;
            }
            catch (SocketException e) {
                ThreadUtils.sleep(this.retryTimeout);
                LOG.warning("Connection failed, retrying");
                lastError = e;
                ++tries;
            }
            catch (ConnectionClosedException e) {
                ThreadUtils.sleep(this.retryTimeout);
                LOG.warning("Connection failed, retrying");
                lastError = e;
                ++tries;
            }
            catch (NoHttpResponseException e) {
                ThreadUtils.sleep(this.retryTimeout);
                LOG.warning("Connection failed, retrying");
                lastError = e;
                ++tries;
            }
        }
        if ((long)tries < this.maxTries) {
            return response;
        }
        throw new IOException("Tried to connect three times to: " + url, lastError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleErrorStatus(String status, byte[] bytes, boolean returnBinary) throws IOException {
        StringBuilder msg = new StringBuilder();
        try {
            String errors = this.map(new ByteArrayInputStream(bytes), returnBinary).getErrors();
            if (StringUtils.isNotBlank(errors)) {
                msg.append(", ").append(errors);
            }
        }
        catch (Exception e) {
            LOG.warning("unable to parse error from response.");
        }
        finally {
            if (StringUtils.isBlank(msg)) {
                msg.append(BODY).append(StringUtils.toEncodedString(bytes, UTF_8));
            }
        }
        throw new IOException(EXCEPTION_FROM_BRIDGE + status + msg.toString());
    }

    protected URI generateURI(String url, Map<String, String> params, int tries) throws URISyntaxException {
        URIBuilder u = new URIBuilder(url);
        if (MapUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                u.addParameter(e.getKey(), e.getValue());
            }
        }
        u.addParameter("retry", Integer.toString(tries));
        return u.build();
    }

    public Results search(Request request) throws IOException {
        this.makeBackwardsCompatible(request);
        String json = this.getJson(request);
        Boolean returnBinary = request.getReturnBinary() == null ? false : request.getReturnBinary();
        InputStream data = this.fireRequest(this.getBridgeUrl(), request.getQueryUrlParams(), json, returnBinary);
        return this.map(data, returnBinary);
    }

    private void makeBackwardsCompatible(Request request) {
        request.setClientKey(this.clientKey);
        if (request.getSkip() == null) {
            request.setSkip(0);
        }
        if (request.getPageSize() == null) {
            request.setPageSize(10);
        }
        if (request.getReturnBinary() != null && !request.getReturnBinary().booleanValue()) {
            request.setReturnBinary(null);
        }
    }

    private String getJson(Object request) {
        String json;
        try {
            json = Mappers.writeValueAsString(request);
        }
        catch (IllegalArgumentException e) {
            json = "{}";
        }
        return json;
    }

    public RefinementsResult refinements(Query query, String navigationName) throws IOException {
        InputStream data = this.fireRequest(this.getBridgeRefinementsUrl(), query.getQueryUrlParams(), query.getBridgeRefinementsJson(this.clientKey, navigationName), query.isReturnBinary());
        return this.mapRefinements(data, query.isReturnBinary());
    }

    public String getBridgeRefinementsUrl() {
        return this.bridgeRefinementsUrl;
    }

    protected RefinementsResult mapRefinements(InputStream data, boolean returnBinary) {
        return Mappers.readValue(data, RefinementsResult.class, returnBinary);
    }

    public RefinementsResult refinements(RefinementsRequest request) throws IOException {
        this.makeBackwardsCompatible(request.getOriginalQuery());
        String json = this.getJson(request);
        Boolean returnBinary = request.getOriginalQuery().getReturnBinary() == null ? false : request.getOriginalQuery().getReturnBinary();
        InputStream data = this.fireRequest(this.getBridgeRefinementsUrl(), request.getOriginalQuery().getQueryUrlParams(), json, returnBinary);
        return this.mapRefinements(data, returnBinary);
    }

    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setRetryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public void setMaxTries(long maxTries) {
        this.maxTries = maxTries;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public static AesContent generateSecuredPayload(String customerId, String clientKey, Query query) throws GeneralSecurityException {
        return AbstractBridge.generateSecuredPayload(customerId, clientKey, query.getBridgeJson(null));
    }

    public static AesContent generateSecuredPayload(String customerId, String clientKey, String requestJson) throws GeneralSecurityException {
        AesEncryption encryption = new AesEncryption(clientKey, customerId);
        return encryption.encrypt(requestJson);
    }

    public AesContent generateSecuredPayload(String customerId, Query query) throws GeneralSecurityException {
        return AbstractBridge.generateSecuredPayload(customerId, this.clientKey, query);
    }
}

