/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.IsolatedScopeQuery;
import com.groupbyinc.common.jackson.jq.internal.javacc.JsonQueryParser;
import com.groupbyinc.common.jackson.jq.internal.javacc.ParseException;
import com.groupbyinc.common.jackson.jq.internal.javacc.TokenMgrError;
import java.util.ArrayList;
import java.util.List;

public abstract class JsonQuery {
    private static Scope defaultScope = new Scope();

    public abstract List<JsonNode> apply(Scope var1, JsonNode var2) throws JsonQueryException;

    public List<JsonNode> apply(JsonNode in) throws JsonQueryException {
        return this.apply(defaultScope, in);
    }

    public List<JsonNode> apply(Scope scope, List<JsonNode> in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode i : in) {
            out.addAll(this.apply(scope, i));
        }
        return out;
    }

    public List<JsonNode> apply(List<JsonNode> in) throws JsonQueryException {
        return this.apply(defaultScope, in);
    }

    public static JsonQuery compile(String path) throws JsonQueryException {
        try {
            return new IsolatedScopeQuery(JsonQueryParser.compile(path));
        }
        catch (ParseException | TokenMgrError e) {
            throw new JsonQueryException(e);
        }
    }
}

