/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeComparator;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Pair;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@BuiltinFunction(value={"sort/1"})
public class SortFunction
implements Function {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode items) throws JsonQueryException {
        Preconditions.checkInputType("sort", items, JsonNodeType.ARRAY);
        ArrayList zipped = new ArrayList(items.size());
        for (JsonNode item : items) {
            ArrayNode value = JsonNodeUtils.asArrayNode(scope.getObjectMapper(), args.get(0).apply(scope, item));
            zipped.add(Pair.of(item, value));
        }
        Collections.sort(zipped, new Comparator<Pair<JsonNode, JsonNode>>(){

            @Override
            public int compare(Pair<JsonNode, JsonNode> o1, Pair<JsonNode, JsonNode> o2) {
                return comparator.compare((JsonNode)o1._2, (JsonNode)o2._2);
            }
        });
        return Collections.singletonList(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), Pair._1(zipped)));
    }
}

