/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.UnicodeUtils;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"length/0"})
public class LengthFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        out.add(this.length(in));
        return out;
    }

    public JsonNode length(JsonNode in) throws JsonQueryException {
        if (in.isTextual()) {
            return IntNode.valueOf(UnicodeUtils.lengthUtf32(in.asText()));
        }
        if (in.isArray() || in.isObject()) {
            return new IntNode(in.size());
        }
        if (in.isNull()) {
            return new IntNode(0);
        }
        if (in.isNumber()) {
            return JsonNodeUtils.asNumericNode(Math.abs(in.asDouble()));
        }
        throw JsonQueryException.format("%s has no length", new Object[]{in.getNodeType()});
    }
}

