/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Pair;
import java.util.ArrayList;
import java.util.List;

public class Conditional
extends JsonQuery {
    private JsonQuery otherwise;
    private List<Pair<JsonQuery, JsonQuery>> switches;

    public Conditional(List<Pair<JsonQuery, JsonQuery>> switches, JsonQuery otherwise) {
        this.switches = switches;
        this.otherwise = otherwise;
    }

    private void applyRecursive(List<JsonNode> out, Scope scope, List<Pair<JsonQuery, JsonQuery>> switches, JsonNode in) throws JsonQueryException {
        Pair<JsonQuery, JsonQuery> sw = switches.get(0);
        List<JsonNode> rs = ((JsonQuery)sw._1).apply(scope, in);
        for (JsonNode r : rs) {
            if (JsonNodeUtils.asBoolean(r)) {
                out.addAll(((JsonQuery)sw._2).apply(scope, in));
                continue;
            }
            if (switches.size() > 1) {
                this.applyRecursive(out, scope, switches.subList(1, switches.size()), in);
                continue;
            }
            out.addAll(this.otherwise.apply(scope, in));
        }
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        this.applyRecursive(out, scope, this.switches, in);
        return out;
    }

    public String toString() {
        String ifstr = "if";
        StringBuilder builder = new StringBuilder();
        for (Pair<JsonQuery, JsonQuery> sw : this.switches) {
            builder.append(ifstr);
            builder.append(" ");
            builder.append(sw._1 != null ? sw._1 : "null");
            builder.append(" ");
            builder.append("then");
            builder.append(" ");
            builder.append(sw._2 != null ? sw._2 : "null");
            builder.append(" ");
            ifstr = "elif";
        }
        builder.append("else ");
        builder.append(this.otherwise != null ? this.otherwise : "null");
        builder.append(" ");
        builder.append("end");
        return builder.toString();
    }
}

