/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import java.util.ArrayList;
import java.util.List;

public class NegativeExpression
extends JsonQuery {
    private JsonQuery value;

    public NegativeExpression(JsonQuery value) {
        this.value = value;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode i : this.value.apply(scope, in)) {
            if (!i.isNumber()) {
                throw new JsonQueryTypeException(in, "cannot be negated");
            }
            out.add(JsonNodeUtils.asNumericNode(-i.asDouble()));
        }
        return out;
    }

    public String toString() {
        return "-(" + this.value.toString() + ")";
    }
}

