/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"implode/0"})
public class ImplodeFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputArrayType("implode", in, JsonNodeType.NUMBER);
        StringBuilder builder = new StringBuilder();
        for (JsonNode ch : in) {
            if (ch.canConvertToInt()) {
                builder.append((char)ch.asInt());
                continue;
            }
            throw new JsonQueryException("input to implode() must be a list of codepoints; " + (Object)((Object)ch.getNodeType()) + " found");
        }
        return Collections.singletonList(new TextNode(builder.toString()));
    }
}

