package com.groupbyinc.common.util;

import com.groupbyinc.common.util.exception.ValidationException;
import org.apache.commons.collections4.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import java.util.Set;

import static java.util.stream.Collectors.toList;

/**
 * ValidatorUtil
 *
 * @author Amir Behnam
 */
public class ValidatorUtil {

  private static final String ERR_OBJECT_IS_NULL = "Internal error";

  public static <T> void validate(Validator validator, T object) throws ValidationException {
    if (object == null) {
      throw new ValidationException(ERR_OBJECT_IS_NULL);
    } else {
      Set<ConstraintViolation<T>> errors = validator.validate(object);
      if (CollectionUtils.isNotEmpty(errors)) {
        throw new ValidationException(errors.stream().map(ConstraintViolation::getMessage).collect(toList()));
      }
    }
  }
}