/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.security;

import com.groupbyinc.common.apache.commons.codec.binary.Base64;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.security.AesContent;
import com.groupbyinc.common.security.AesUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesEncryption {
    public static final int CLIENT_KEY_HASHING_ITERATIONS = 5000;
    private SecretKey encryptionKey;
    private SecretKey macKey;
    private Cipher cipher;
    private Mac hmac;

    public AesEncryption(String clientKey, String customerId) throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this(clientKey, customerId, (Provider)new BouncyCastleProvider());
    }

    public AesEncryption(String clientKey, String customerId, Provider provider) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        Security.addProvider(provider);
        this.cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(clientKey.toCharArray(), AesUtil.geEncryptSalt(customerId).getBytes(StandardCharsets.UTF_8), 5000, 128);
        PBEKeySpec macSpec = new PBEKeySpec(clientKey.toCharArray(), AesUtil.getMessageAuthenticationCodeSalt(customerId).getBytes(StandardCharsets.UTF_8), 5000, 160);
        this.encryptionKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        this.macKey = new SecretKeySpec(factory.generateSecret(macSpec).getEncoded(), "HmacSHA256");
        this.hmac = Mac.getInstance("HmacSHA256");
        this.hmac.init(this.macKey);
    }

    public AesContent encrypt(String message) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (StringUtils.isBlank(message)) {
            throw new IllegalStateException("cannot encrypt null message");
        }
        this.cipher.init(1, (Key)this.encryptionKey, new SecureRandom());
        byte[] cipherText = this.cipher.doFinal(message.getBytes(StandardCharsets.UTF_8));
        byte[] encodedCipherText = Base64.encodeBase64(cipherText);
        byte[] iv = this.cipher.getIV();
        byte[] encodedIv = Base64.encodeBase64(iv);
        byte[] ciperTextAndIv = new byte[cipherText.length + iv.length];
        System.arraycopy(cipherText, 0, ciperTextAndIv, 0, cipherText.length);
        System.arraycopy(iv, 0, ciperTextAndIv, cipherText.length, iv.length);
        byte[] mac = this.hmac.doFinal(ciperTextAndIv);
        byte[] encodedMac = Base64.encodeBase64(mac);
        return new AesContent(new String(encodedCipherText, StandardCharsets.UTF_8), new String(encodedIv, StandardCharsets.UTF_8), new String(encodedMac, StandardCharsets.UTF_8));
    }
}

