/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractBridge;
import com.groupbyinc.api.config.ConnectionConfiguration;
import com.groupbyinc.common.apache.http.Header;
import com.groupbyinc.common.apache.http.message.BasicHeader;
import java.util.Iterator;

public class CloudBridge
extends AbstractBridge {
    private static final String DOT = ".";
    private static final String CLOUD_HOST = "groupbycloud.com";
    private static final int CLOUD_PORT = 443;
    private static final String CLOUD_PATH = "/api/v1";
    private static final String URL_SUFFIX = ".groupbycloud.com:443/api/v1";

    public CloudBridge(String clientKey, String customerId) {
        super(clientKey, "https://" + customerId + URL_SUFFIX);
    }

    public CloudBridge(String clientKey, String customerId, ConnectionConfiguration config) {
        super(clientKey, "https://" + customerId + URL_SUFFIX, config);
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        if (this.containsSkipCachingHeader()) {
            if (cachingEnabled) {
                this.removeSkipCachingHeader();
            }
        } else if (!cachingEnabled) {
            this.addSkipCachingHeader();
        }
    }

    private boolean containsSkipCachingHeader() {
        for (Header header : this.getHeaders()) {
            if (!header.getName().equalsIgnoreCase("Skip-Caching")) continue;
            return true;
        }
        return false;
    }

    private void removeSkipCachingHeader() {
        Iterator<Header> iterator = this.getHeaders().iterator();
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getName().equalsIgnoreCase("Skip-Caching")) continue;
            iterator.remove();
        }
    }

    private void addSkipCachingHeader() {
        this.getHeaders().add(new BasicHeader("Skip-Caching", "true"));
    }
}

