/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.http.client.protocol;

import com.groupbyinc.common.apache.http.HttpEntity;
import com.groupbyinc.common.apache.http.HttpEntityEnclosingRequest;
import com.groupbyinc.common.apache.http.HttpException;
import com.groupbyinc.common.apache.http.HttpRequest;
import com.groupbyinc.common.apache.http.HttpRequestInterceptor;
import com.groupbyinc.common.apache.http.HttpVersion;
import com.groupbyinc.common.apache.http.ProtocolVersion;
import com.groupbyinc.common.apache.http.annotation.Immutable;
import com.groupbyinc.common.apache.http.client.config.RequestConfig;
import com.groupbyinc.common.apache.http.client.protocol.HttpClientContext;
import com.groupbyinc.common.apache.http.protocol.HttpContext;
import com.groupbyinc.common.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

