/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.exception;

import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MultipleErrorsException
extends Exception {
    private Collection<String> errors;

    public MultipleErrorsException(Collection<String> errors) {
        super(MultipleErrorsException.buildMessageFromErrors(CollectionUtils.isEmpty(errors) ? Stream.empty() : errors.stream()));
        this.errors = CollectionUtils.isEmpty(errors) ? Collections.emptyList() : (Collection)errors.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    public MultipleErrorsException(String ... errors) {
        this(Arrays.asList(errors));
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    private static String buildMessageFromErrors(Stream<String> errorStream) {
        List errorMessages = errorStream.map(StringUtils::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(errorMessages)) {
            return "No error details available";
        }
        if (errorMessages.size() == 1) {
            return (String)errorMessages.get(0);
        }
        return "Multiple errors occurred: " + StringUtils.join(errorMessages, ", ");
    }
}

