/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import com.groupbyinc.common.util.DefaultForkJoinWorkerThreadFactory;
import com.groupbyinc.common.util.DefaultThreadFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);
    private static final int MAX_PARALLELISM = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);

    private ThreadUtils() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.warn(ie.getMessage(), (Throwable)ie);
        }
    }

    public static ThreadFactory defaultThreadFactory(String name) {
        return ThreadUtils.defaultThreadFactory(name, false);
    }

    public static ThreadFactory defaultThreadFactory(String name, boolean includeThreadNumber) {
        return ThreadUtils.defaultThreadFactory(name, includeThreadNumber, true);
    }

    public static ThreadFactory defaultThreadFactory(String name, boolean includeThreadNumber, boolean includeParentThreadName) {
        return new DefaultThreadFactory(name, includeThreadNumber, includeParentThreadName);
    }

    public static ForkJoinPool newForkJoinPool(String name, boolean includeThreadName) {
        return ThreadUtils.newForkJoinPool(MAX_PARALLELISM, name, includeThreadName);
    }

    public static ForkJoinPool newForkJoinPool(int parallelism, String name, boolean includeThreadName) {
        DefaultForkJoinWorkerThreadFactory factory = new DefaultForkJoinWorkerThreadFactory(Thread.currentThread().getName(), name, includeThreadName);
        return new ForkJoinPool(Math.max(1, parallelism), factory, null, false);
    }

    public static ExecutorService newFixedPool(int parallelism, String name, boolean includeThreadName) {
        return ThreadUtils.newFixedPool(parallelism, Integer.MAX_VALUE, name, includeThreadName);
    }

    public static ExecutorService newFixedPool(int parallelism, int queueSize, String name, boolean includeThreadName) {
        ThreadFactory factory = ThreadUtils.defaultThreadFactory(name, includeThreadName);
        return new ThreadPoolExecutor(parallelism, parallelism, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), factory);
    }

    public static ExecutorService newBlockingFixedPool(int parallelism, String name, boolean includeThreadName) {
        return ThreadUtils.newBlockingFixedPool(parallelism, 0, name, includeThreadName);
    }

    public static ExecutorService newBlockingFixedPool(int parallelism, int queueSize, String name, boolean includeThreadName) {
        SynchronousQueue<Runnable> queue = queueSize < 1 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
        ThreadFactory factory = ThreadUtils.defaultThreadFactory(name, includeThreadName);
        return new ThreadPoolExecutor(parallelism, parallelism, 0L, TimeUnit.MILLISECONDS, queue, factory, (runnable, executor) -> {
            try {
                executor.getQueue().put(runnable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    public static void async(ForkJoinPool workers, Runnable runnable, Function<Exception, String> errorMessage) {
        ThreadUtils.async(workers, runnable, null, errorMessage);
    }

    public static void async(ForkJoinPool workers, Runnable runnable, Supplier<String> successMessage, Function<Exception, String> errorMessage) {
        Future task = workers.submit(runnable);
        try {
            ((ForkJoinTask)task).get();
            if (successMessage != null) {
                LOG.info("{}", (Object)successMessage.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(errorMessage.apply(e), (Throwable)e);
        }
    }
}

