/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.databind.ser.std;

import com.groupbyinc.common.jackson.core.JsonGenerator;
import com.groupbyinc.common.jackson.databind.JavaType;
import com.groupbyinc.common.jackson.databind.JsonMappingException;
import com.groupbyinc.common.jackson.databind.SerializerProvider;
import com.groupbyinc.common.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.groupbyinc.common.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.groupbyinc.common.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.groupbyinc.common.jackson.databind.ser.std.StdScalarSerializer;
import com.groupbyinc.common.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

