/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api.request;

import com.groupbyinc.api.model.CustomUrlParam;
import com.groupbyinc.api.request.Bias;
import com.groupbyinc.api.request.Biasing;
import com.groupbyinc.api.request.NumericBoost;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.api.request.SelectedRefinement;
import com.groupbyinc.common.apache.commons.collections4.CollectionUtils;
import com.groupbyinc.common.apache.commons.lang3.ObjectUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RequestUtil {
    private static final Comparator<String> STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return ObjectUtils.compare((Comparable)((Object)o1), (Comparable)((Object)o2));
        }
    };
    private static final Comparator<CustomUrlParam> CUSTOM_URL_PARAM_COMPARATOR = new Comparator<CustomUrlParam>(){

        @Override
        public int compare(CustomUrlParam o1, CustomUrlParam o2) {
            int compareTo = ObjectUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey()));
            if (compareTo == 0) {
                compareTo = ObjectUtils.compare((Comparable)((Object)o1.getValue()), (Comparable)((Object)o2.getValue()));
            }
            return compareTo;
        }
    };
    private static final Comparator<SelectedRefinement> SELECTED_REFINEMENT_COMPARATOR = new Comparator<SelectedRefinement>(){

        @Override
        public int compare(SelectedRefinement o1, SelectedRefinement o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.toTildeString()), (Comparable)((Object)o2.toTildeString()));
        }
    };
    private static final Comparator<Bias> BIAS_COMPARATOR = new Comparator<Bias>(){

        @Override
        public int compare(Bias o1, Bias o2) {
            int compareTo = ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            if (compareTo == 0) {
                compareTo = ObjectUtils.compare((Comparable)((Object)o1.getContent()), (Comparable)((Object)o2.getContent()));
            }
            if (compareTo == 0) {
                compareTo = ObjectUtils.compare((Comparable)((Object)o1.getStrength()), (Comparable)((Object)o2.getStrength()));
            }
            return compareTo;
        }
    };
    private static final Comparator<NumericBoost> NUMERIC_BOOST_COMPARATOR = new Comparator<NumericBoost>(){

        @Override
        public int compare(NumericBoost o1, NumericBoost o2) {
            int compareTo = ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            if (compareTo == 0) {
                compareTo = ObjectUtils.compare((Comparable)Double.valueOf(o1.getStrength()), (Comparable)Double.valueOf(o2.getStrength()));
            }
            if (compareTo == 0) {
                compareTo = ObjectUtils.compare((Comparable)Boolean.valueOf(o1.isInverted()), (Comparable)Boolean.valueOf(o2.isInverted()));
            }
            return compareTo;
        }
    };

    public static Request normalizeRequest(Request request) {
        if (request == null) {
            return null;
        }
        RequestUtil.sort(request.getCustomUrlParams(), CUSTOM_URL_PARAM_COMPARATOR);
        RequestUtil.sort(request.getRefinements(), SELECTED_REFINEMENT_COMPARATOR);
        Biasing biasing = request.getBiasing();
        if (biasing != null) {
            RequestUtil.sort(biasing.getBiases(), BIAS_COMPARATOR);
            RequestUtil.sort(biasing.getNumericBoosts(), NUMERIC_BOOST_COMPARATOR);
            RequestUtil.sort(biasing.getRestrictToIds(), STRING_COMPARATOR);
        }
        RequestUtil.sort(request.getIncludedNavigations(), STRING_COMPARATOR);
        RequestUtil.sort(request.getExcludedNavigations(), STRING_COMPARATOR);
        RequestUtil.sort(request.getOrFields(), STRING_COMPARATOR);
        RequestUtil.sort(request.getFields(), STRING_COMPARATOR);
        return request;
    }

    public static Request normalizeCacheKey(Request request) {
        if (request == null) {
            return null;
        }
        request.setVisitorId("cache").setSessionId("cache").setClientKey("cache");
        return RequestUtil.normalizeRequest(request);
    }

    private static <T> void sort(List<T> list, Comparator<T> comparator) {
        if (CollectionUtils.isNotEmpty(list)) {
            Collections.sort(list, comparator);
        }
    }
}

