/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractBridge;
import com.groupbyinc.api.config.ConnectionConfiguration;

public class CloudBridge
extends AbstractBridge {
    private static final String DOT = ".";
    private static final String CLOUD_HOST = "groupbycloud.com";
    private static final int CLOUD_PORT = 443;
    private static final String CLOUD_PATH = "/api/v1";
    private static final String URL_SUFFIX = ".groupbycloud.com:443/api/v1";
    private static final String SKIP_CACHING_HEADER_KEY = "Skip-Caching";

    public CloudBridge(String clientKey, String customerId) {
        super(clientKey, "https://" + customerId + URL_SUFFIX);
    }

    public CloudBridge(String clientKey, String customerId, ConnectionConfiguration config) {
        super(clientKey, "https://" + customerId + URL_SUFFIX, config);
    }

    public synchronized void setCachingEnabled(boolean cachingEnabled) {
        if (CloudBridge.containsHeader(this.getHeaders(), SKIP_CACHING_HEADER_KEY)) {
            if (cachingEnabled) {
                CloudBridge.removeHeader(this.getHeaders(), SKIP_CACHING_HEADER_KEY);
            }
        } else if (!cachingEnabled) {
            CloudBridge.addHeader(this.getHeaders(), SKIP_CACHING_HEADER_KEY, "true");
        }
    }
}

