/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.IllegalJsonArgumentException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import com.groupbyinc.common.jackson.jq.internal.tree.ThisObject;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"del/1"})
public class DelFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("del", in, JsonNodeType.OBJECT, JsonNodeType.ARRAY, JsonNodeType.NULL);
        JsonQuery arg = args.get(0);
        if (!(arg instanceof FieldAccess)) {
            throw new IllegalJsonArgumentException("1st argument to del() must be a field access");
        }
        FieldAccess.ResolvedPath resolvedPath = ((FieldAccess)arg).resolvePath(scope, in);
        if (!(resolvedPath.target instanceof ThisObject)) {
            throw new IllegalJsonArgumentException("cannot delete from " + resolvedPath.target);
        }
        return Collections.singletonList(JsonNodeUtils.mutate(scope.getObjectMapper(), in, resolvedPath.path, new JsonNodeUtils.Mutation(){

            @Override
            public JsonNode apply(JsonNode value) {
                return null;
            }
        }, false));
    }
}

