/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"from_entries/0"})
public class FromEntriesFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputArrayType("from_entries", in, JsonNodeType.OBJECT);
        ObjectNode out = scope.getObjectMapper().createObjectNode();
        for (JsonNode entry : in) {
            JsonNode key = entry.get("key");
            if (key == null) {
                key = entry.get("Key");
            }
            if (key == null) {
                key = entry.get("name");
            }
            if (key == null) {
                key = entry.get("Name");
            }
            if (key == null || !key.isTextual()) {
                throw new JsonQueryException("input elements to from_entries() must be object and have 'key', 'Key' or 'Name' field");
            }
            JsonNode value = entry.get("value");
            if (value == null) {
                value = entry.get("Value");
            }
            out.set(key.asText(), value == null ? NullNode.getInstance() : value);
        }
        return Collections.singletonList(out);
    }
}

