/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"rtrimstr/1"})
public class RTrimStrFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("rtrimstr", in, JsonNodeType.STRING);
        String text = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode suffixNode : args.get(0).apply(scope, in)) {
            if (!suffixNode.isTextual()) {
                throw new JsonQueryException("1st argument to rtrimstr() must be string, got " + (Object)((Object)suffixNode.getNodeType()));
            }
            String suffix = suffixNode.asText();
            if (!text.endsWith(suffix)) {
                out.add(in);
                continue;
            }
            out.add(new TextNode(text.substring(0, text.length() - suffix.length())));
        }
        return out;
    }
}

