/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.operators;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;
import java.util.regex.Pattern;

public class DivideOperator
implements BinaryOperator {
    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isNumber() && rhs.isNumber()) {
            double divisor = rhs.asDouble();
            double dividend = lhs.asDouble();
            if (divisor == 0.0) {
                throw JsonQueryException.format("number (%s) and number (%s) cannot be divided because the divisor is zero", dividend, divisor);
            }
            return JsonNodeUtils.asNumericNode(dividend / divisor);
        }
        if (lhs.isTextual() && rhs.isTextual()) {
            ArrayNode result = mapper.createArrayNode();
            for (String token : lhs.asText().split(Pattern.quote(rhs.asText()))) {
                result.add(new TextNode(token));
            }
            return result;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be divided");
    }

    @Override
    public String image() {
        return "/";
    }
}

