/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import java.util.Collections;
import java.util.List;

public class ArrayConstruction
extends JsonQuery {
    private JsonQuery q;

    public ArrayConstruction() {
        this(null);
    }

    public ArrayConstruction(JsonQuery q) {
        this.q = q;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayNode array = new ArrayNode(scope.getObjectMapper().getNodeFactory());
        if (this.q != null) {
            array.addAll(this.q.apply(scope, in));
        }
        return Collections.singletonList(array);
    }

    public String toString() {
        if (this.q == null) {
            return String.format("[]", new Object[0]);
        }
        return String.format("[%s]", this.q);
    }
}

