/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import java.util.Collections;
import java.util.List;

public class FormattingFilter
extends JsonQuery {
    private String name;

    public FormattingFilter(String name) {
        this.name = name;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        Function f = scope.getFunction("@" + this.name, 0);
        if (f == null) {
            throw new JsonQueryException("Formatting operator @" + this.name + " does not exist");
        }
        return f.apply(scope, Collections.emptyList(), in);
    }

    public String toString() {
        return "@" + this.name;
    }
}

