/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.binaryop;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.BooleanNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import java.util.ArrayList;
import java.util.List;

public class BooleanAndExpression
extends BinaryOperatorExpression {
    public BooleanAndExpression(JsonQuery lhs, JsonQuery rhs) {
        super(lhs, rhs, "and");
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode l : this.lhs.apply(scope, in)) {
            if (!JsonNodeUtils.asBoolean(l)) {
                out.add(BooleanNode.FALSE);
                continue;
            }
            for (JsonNode r : this.rhs.apply(scope, in)) {
                out.add(BooleanNode.valueOf(JsonNodeUtils.asBoolean(r)));
            }
        }
        return out;
    }
}

